"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createTag = void 0;
var _get_ramdom_color = require("../../../../common/utils/get_ramdom_color");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createTag = async ({
  savedObjectsClient,
  tagName,
  description,
  color,
  references
}) => {
  const createdTag = await savedObjectsClient.create('tag', {
    name: tagName,
    description,
    color: color !== null && color !== void 0 ? color : (0, _get_ramdom_color.getRandomColor)()
  }, {
    references
  });
  return createdTag;
};
exports.createTag = createTag;