"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.translateRuleState = void 0;
var _langgraph = require("@langchain/langgraph");
var _constants = require("../../../../../../../../common/siem_migrations/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const translateRuleState = exports.translateRuleState = _langgraph.Annotation.Root({
  original_rule: (0, _langgraph.Annotation)(),
  resources: (0, _langgraph.Annotation)(),
  integration: (0, _langgraph.Annotation)({
    reducer: (current, value) => value !== null && value !== void 0 ? value : current,
    default: () => ({})
  }),
  includes_ecs_mapping: (0, _langgraph.Annotation)({
    reducer: (current, value) => value !== null && value !== void 0 ? value : current,
    default: () => false
  }),
  inline_query: (0, _langgraph.Annotation)({
    reducer: (current, value) => value !== null && value !== void 0 ? value : current,
    default: () => ''
  }),
  semantic_query: (0, _langgraph.Annotation)({
    reducer: (current, value) => value !== null && value !== void 0 ? value : current,
    default: () => ''
  }),
  elastic_rule: (0, _langgraph.Annotation)({
    reducer: (state, action) => ({
      ...state,
      ...action
    }),
    default: () => ({})
  }),
  validation_errors: (0, _langgraph.Annotation)({
    reducer: (current, value) => value !== null && value !== void 0 ? value : current,
    default: () => ({
      retries_left: 3
    })
  }),
  translation_result: (0, _langgraph.Annotation)({
    reducer: (current, value) => value !== null && value !== void 0 ? value : current,
    default: () => _constants.MigrationTranslationResult.UNTRANSLATABLE
  }),
  comments: (0, _langgraph.Annotation)({
    reducer: (current, value) => value ? (current !== null && current !== void 0 ? current : []).concat(value) : current,
    default: () => []
  })
});