"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerSiemMigrationsRoutes = void 0;
var _api = require("./rules/api");
var _api2 = require("./dashboards/api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerSiemMigrationsRoutes = (router, config, logger) => {
  if (!config.experimentalFeatures.siemMigrationsDisabled) {
    (0, _api.registerSiemRuleMigrationsRoutes)(router, config, logger);
    if (config.experimentalFeatures.automaticDashboardsMigration) {
      (0, _api2.registerSiemDashboardMigrationsRoutes)(router, config, logger);
    }
  }
};
exports.registerSiemMigrationsRoutes = registerSiemMigrationsRoutes;