"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrateDashboardState = exports.migrateDashboardConfigSchema = void 0;
var _langgraph = require("@langchain/langgraph");
var _fp = require("lodash/fp");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const migrateDashboardState = exports.migrateDashboardState = _langgraph.Annotation.Root({
  id: (0, _langgraph.Annotation)(),
  original_dashboard: (0, _langgraph.Annotation)(),
  parsed_original_dashboard: (0, _langgraph.Annotation)(),
  description: (0, _langgraph.Annotation)(),
  panel_descriptions: (0, _langgraph.Annotation)(),
  translated_panels: (0, _langgraph.Annotation)({
    reducer: (current, value) => current.concat(value),
    default: () => []
  }),
  elastic_dashboard: (0, _langgraph.Annotation)({
    reducer: (current, value) => ({
      ...current,
      ...value
    })
  }),
  resources: (0, _langgraph.Annotation)(),
  translation_result: (0, _langgraph.Annotation)(),
  comments: (0, _langgraph.Annotation)({
    // Translation subgraph causes the original main graph comments to be concatenated again, we need to deduplicate them.
    reducer: (current, value) => (0, _fp.uniq)(value ? (current !== null && current !== void 0 ? current : []).concat(value) : current),
    default: () => []
  })
});
const migrateDashboardConfigSchema = exports.migrateDashboardConfigSchema = _langgraph.Annotation.Root({
  skipPrebuiltDashboardsMatching: (0, _langgraph.Annotation)()
});