"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCreateDescriptionsNode = void 0;
var _output_parsers = require("@langchain/core/output_parsers");
var _prompts = require("./prompts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getCreateDescriptionsNode = params => {
  return async state => {
    var _response$panel_descr;
    const {
      model
    } = params;
    const createDescriptions = _prompts.CREATE_DESCRIPTIONS_PROMPT.pipe(model).pipe(new _output_parsers.JsonOutputParser());
    const panels = state.parsed_original_dashboard.panels.map(panel => ({
      id: panel.id,
      title: panel.title,
      viz_type: panel.viz_type
    }));
    const response = await createDescriptions.invoke({
      dashboard_title: state.parsed_original_dashboard.title,
      panels_json: JSON.stringify(panels, null, 2)
    });
    return {
      description: response.dashboard_description,
      panel_descriptions: (_response$panel_descr = response.panel_descriptions) !== null && _response$panel_descr !== void 0 ? _response$panel_descr : {}
    };
  };
};
exports.getCreateDescriptionsNode = getCreateDescriptionsNode;