"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerSiemDashboardMigrationsDeleteRoute = void 0;
var _zodHelpers = require("@kbn/zod-helpers");
var _dashboard_migration = require("../../../../../common/siem_migrations/model/api/dashboards/dashboard_migration.gen");
var _constants = require("../../../../../common/siem_migrations/dashboards/constants");
var _authz = require("../../common/api/util/authz");
var _with_license = require("../../common/api/util/with_license");
var _audit = require("../../common/api/util/audit");
var _with_existing_migration_id = require("../../common/api/util/with_existing_migration_id");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerSiemDashboardMigrationsDeleteRoute = (router, logger) => {
  router.versioned.delete({
    path: _constants.SIEM_DASHBOARD_MIGRATION_PATH,
    access: 'internal',
    security: {
      authz: _authz.authz
    }
  }).addVersion({
    version: '1',
    validate: {
      request: {
        params: (0, _zodHelpers.buildRouteValidationWithZod)(_dashboard_migration.DeleteDashboardMigrationRequestParams)
      }
    }
  }, (0, _with_license.withLicense)((0, _with_existing_migration_id.withExistingMigration)(async (context, req, res) => {
    const {
      migration_id: migrationId
    } = req.params;
    const dashboardMigrationsAuditLogger = new _audit.SiemMigrationAuditLogger(context.securitySolution, 'dashboards');
    try {
      const ctx = await context.resolve(['securitySolution']);
      const dashboardMigrationsClient = ctx.securitySolution.siemMigrations.getDashboardsClient();
      await dashboardMigrationsAuditLogger.logDeleteMigration({
        migrationId
      });
      if (dashboardMigrationsClient.task.isMigrationRunning(migrationId)) {
        return res.conflict({
          body: 'A running dashboard migration cannot be deleted. Please stop the migration first and try again'
        });
      }
      await dashboardMigrationsClient.data.deleteMigration(migrationId);
      return res.ok();
    } catch (error) {
      logger.error(error);
      await dashboardMigrationsAuditLogger.logDeleteMigration({
        migrationId,
        error
      });
      return res.customError({
        statusCode: 500,
        body: error
      });
    }
  })));
};
exports.registerSiemDashboardMigrationsDeleteRoute = registerSiemDashboardMigrationsDeleteRoute;