"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildPipelineRequest = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const buildPipelineRequest = mappings => {
  return {
    _meta: {
      managed: true
    },
    description: 'Pipeline for routing events from Cribl',
    processors: buildCriblRoutingProcessors(mappings),
    on_failure: [{
      set: {
        field: 'error.message',
        value: '{{ _ingest.on_failure_message }}'
      }
    }]
  };
};
exports.buildPipelineRequest = buildPipelineRequest;
const buildCriblRoutingProcessors = mappings => {
  const processors = [];
  mappings.forEach(function (mapping) {
    const [, datasetName] = mapping.datastream.split('-');
    processors.push({
      reroute: {
        dataset: `${datasetName}`,
        if: `ctx['_dataId'] == '${mapping.dataId}'`,
        namespace: ['default']
      }
    });
  });
  return processors;
};