"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.securityV1SavedObjects = exports.securityTimelineSavedObjects = exports.securityNotesSavedObjects = exports.securityDefaultSavedObjects = void 0;
var _common = require("@kbn/data-views-plugin/common");
var _securitysolutionListConstants = require("@kbn/securitysolution-list-constants");
var _saved_objects = require("../../saved_objects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Same as the saved-object type for rules defined by Cloud Security Posture
const CLOUD_POSTURE_SAVED_OBJECT_RULE_TYPE = 'csp_rule';
const CLOUD_SECURITY_POSTURE_SETTINGS = 'cloud-security-posture-settings';
// Benchmark Rule Templates installed by the Cloud Security Posture package stored as Saved Objects:
const CLOUD_SECURITY_POSTURE_BENCHMARK_RULE_TEMPLATE = 'csp-rule-template';
const securityDefaultSavedObjects = exports.securityDefaultSavedObjects = ['exception-list', _securitysolutionListConstants.EXCEPTION_LIST_NAMESPACE_AGNOSTIC, _common.DATA_VIEW_SAVED_OBJECT_TYPE, ..._saved_objects.savedObjectTypesWithoutTimelineAndWithoutNotes, CLOUD_POSTURE_SAVED_OBJECT_RULE_TYPE, CLOUD_SECURITY_POSTURE_SETTINGS, CLOUD_SECURITY_POSTURE_BENCHMARK_RULE_TEMPLATE];
const securityV1SavedObjects = exports.securityV1SavedObjects = [...securityDefaultSavedObjects, ..._saved_objects.savedObjectTypes];
const securityTimelineSavedObjects = exports.securityTimelineSavedObjects = _saved_objects.timelineSavedObjectTypes;
const securityNotesSavedObjects = exports.securityNotesSavedObjects = _saved_objects.notesSavedObjectTypes;