"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updatePrivilegedMonitoringSourceIndex = exports.MAX_PER_PAGE = void 0;
var _std = require("@kbn/std");
var _fp = require("lodash/fp");
var _monitoring_entity_source_type = require("../saved_objects/monitoring_entity_source_type");
var _api_key = require("../auth/api_key");
var _delete_user_with_source_indices = require("../data_sources/migrations/delete_user_with_source_indices");
var _source_index_update = require("../data_sources/migrations/source_index_update");
var _check_if_entity_source_migration = require("../data_sources/migrations/check_if_entity_source_migration");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_PER_PAGE = exports.MAX_PER_PAGE = 10_000;
const updatePrivilegedMonitoringSourceIndex = async ({
  logger,
  getStartServices
}) => {
  const [core, {
    security,
    encryptedSavedObjects
  }] = await getStartServices();
  const internalEsClient = core.elasticsearch.client.asInternalUser;
  const shouldRunMigration = (0, _check_if_entity_source_migration.shouldRunSourceMigrationFactory)({
    esClient: internalEsClient
  });
  const shouldRun = await shouldRunMigration('*');
  if (!shouldRun) {
    logger.info('Skipping migration for Privileged Monitoring Entity Source.');
    return;
  }
  const soClientGlobal = core.savedObjects.createInternalRepository();
  const savedObjectsResponse = await soClientGlobal.find({
    type: _monitoring_entity_source_type.monitoringEntitySourceTypeName,
    perPage: MAX_PER_PAGE,
    namespaces: ['*']
  });
  await (0, _std.asyncForEach)(savedObjectsResponse.saved_objects, async savedObject => {
    const namespace = (0, _fp.first)(savedObject.namespaces); // We install an entity source on a single space

    if (!namespace) {
      logger.error('Unexpected saved object. Monitoring Entity Source Score saved objects must have a namespace');
      return;
    }
    const apiKeyManager = (0, _api_key.getApiKeyManager)({
      core,
      logger,
      security,
      encryptedSavedObjects,
      namespace
    });
    const client = await apiKeyManager.getClient();
    if (!client) {
      logger.error('[Privilege Monitoring] Unable to create Elasticsearch client from API key.');
      return undefined;
    }
    const migrateSourceIndex = (0, _source_index_update.migrateSourceIndexFactory)({
      logger,
      esClient: client.clusterClient.asCurrentUser
    });
    await migrateSourceIndex(namespace, savedObject.attributes.indexPattern, savedObject.id);
  });
  const deleteUsersWithSourceIndex = (0, _delete_user_with_source_indices.deleteUsersWithSourceIndexFactory)({
    esClient: internalEsClient
  });
  await deleteUsersWithSourceIndex('*');
};
exports.updatePrivilegedMonitoringSourceIndex = updatePrivilegedMonitoringSourceIndex;