"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getErrorFromBulkResponse = exports.errorsMsg = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getErrorFromBulkResponse = resp => resp.errors ? resp.items.map(item => {
  var _item$index$error, _item$index, _item$update;
  return (_item$index$error = (_item$index = item.index) === null || _item$index === void 0 ? void 0 : _item$index.error) !== null && _item$index$error !== void 0 ? _item$index$error : (_item$update = item.update) === null || _item$update === void 0 ? void 0 : _item$update.error;
}).filter(e => e !== undefined) : [];
exports.getErrorFromBulkResponse = getErrorFromBulkResponse;
const errorsMsg = errors => {
  if (errors.length > 0) {
    return errors.map(e => `${e.type}: ${e.reason}`).join('; ');
  }
  return 'No errors found';
};
exports.errorsMsg = errorsMsg;