"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.oktaLastFullSyncMarkersIndex = exports.integrationsSourceIndex = exports.getStreamPatternFor = exports.getMatchersFor = exports.STREAM_INDEX_PATTERNS = exports.PRIVILEGE_MONITORING_PRIVILEGE_CHECK_API = exports.OKTA_ADMIN_ROLES = exports.INTEGRATION_TYPES = exports.INTEGRATION_MATCHERS_DETAILED = exports.AD_ADMIN_GROUPS = void 0;
var _constants = require("../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OKTA_ADMIN_ROLES = exports.OKTA_ADMIN_ROLES = ['Super Administrator', 'Organization Administrator', 'Group Administrator', 'Application Administrator', 'Mobile Administrator', 'Help Desk Administrator', 'Report Administrator', 'API Access Management Administrator', 'Group Membership Administrator', 'Read-only Administrator'];
const AD_ADMIN_GROUPS = exports.AD_ADMIN_GROUPS = ['Domain Admins', 'Enterprise Admins'];
const INTEGRATION_MATCHERS_DETAILED = exports.INTEGRATION_MATCHERS_DETAILED = {
  entityanalytics_okta: {
    fields: ['user.roles'],
    values: OKTA_ADMIN_ROLES
  },
  entityanalytics_ad: {
    fields: ['user.group.name'],
    values: AD_ADMIN_GROUPS
  }
};
const getMatchersFor = integration => [INTEGRATION_MATCHERS_DETAILED[integration]];
// TODO: this should be index source? If so, can follow pattern outlined below.
// e.g. .entity_analytics.monitoring.sources.index-<space>

// .entity_analytics.monitoring.sources.entityanalytics_okta-<space>
exports.getMatchersFor = getMatchersFor;
const integrationsSourceIndex = (namespace, integrationName) => `${_constants.PRIVMON_BASE_INDEX_NAME}.sources.${integrationName}-${namespace}`;
exports.integrationsSourceIndex = integrationsSourceIndex;
const PRIVILEGE_MONITORING_PRIVILEGE_CHECK_API = exports.PRIVILEGE_MONITORING_PRIVILEGE_CHECK_API = '/api/entity_analytics/monitoring/privileges/privileges';
const INTEGRATION_TYPES = exports.INTEGRATION_TYPES = ['entityanalytics_okta', 'entityanalytics_ad'];
const STREAM_INDEX_PATTERNS = exports.STREAM_INDEX_PATTERNS = {
  entityanalytics_okta: namespace => `logs-entityanalytics_okta.user-${namespace}`,
  entityanalytics_ad: namespace => `logs-entityanalytics_ad.user-${namespace}`
};
const getStreamPatternFor = (integration, namespace) => STREAM_INDEX_PATTERNS[integration](namespace);
exports.getStreamPatternFor = getStreamPatternFor;
const oktaLastFullSyncMarkersIndex = namespace => `logs-entityanalytics_okta.entity-${namespace}`;
exports.oktaLastFullSyncMarkersIndex = oktaLastFullSyncMarkersIndex;