"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPrivmonEncryptedSavedObjectId = exports.SO_PRIVILEGE_MONITORING_API_KEY_TYPE = exports.PrivilegeMonitoringApiKeyType = exports.PrivilegeMonitoringApiKeyEncryptionParams = void 0;
var _uuid = require("uuid");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PRIVMON_API_KEY_SO_ID = 'd2ee7992-cb4d-473a-8f1a-44ba187d4ac9';
const getPrivmonEncryptedSavedObjectId = space => {
  return (0, _uuid.v5)(space, PRIVMON_API_KEY_SO_ID);
};
exports.getPrivmonEncryptedSavedObjectId = getPrivmonEncryptedSavedObjectId;
const SO_PRIVILEGE_MONITORING_API_KEY_TYPE = exports.SO_PRIVILEGE_MONITORING_API_KEY_TYPE = 'privmon-api-key';
const PrivilegeMonitoringApiKeyType = exports.PrivilegeMonitoringApiKeyType = {
  name: SO_PRIVILEGE_MONITORING_API_KEY_TYPE,
  hidden: true,
  namespaceType: 'multiple-isolated',
  mappings: {
    dynamic: false,
    properties: {}
  },
  management: {
    importableAndExportable: false,
    displayName: 'Privilege Monitoring API key'
  }
};
const PrivilegeMonitoringApiKeyEncryptionParams = exports.PrivilegeMonitoringApiKeyEncryptionParams = {
  type: SO_PRIVILEGE_MONITORING_API_KEY_TYPE,
  attributesToEncrypt: new Set(['apiKey']),
  attributesToIncludeInAAD: new Set(['id', 'name'])
};