"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createPrivMonAuditLogger = void 0;
var _audit = require("../audit");
var _actions = require("./auditing/actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createPrivMonAuditLogger = auditLogger => {
  return {
    log: (action, resource, msg, error) => {
      // NOTE: Excluding errors, all auditing events are currently WRITE events, meaning the outcome is always UNKNOWN.
      // This may change in the future, depending on the audit action.
      const outcome = error ? _audit.AUDIT_OUTCOME.FAILURE : _audit.AUDIT_OUTCOME.UNKNOWN;
      const type = action === _actions.PrivilegeMonitoringEngineActions.CREATE ? _audit.AUDIT_TYPE.CREATION : _actions.PrivilegeMonitoringEngineActions.DELETE ? _audit.AUDIT_TYPE.DELETION : _audit.AUDIT_TYPE.CHANGE;
      const category = _audit.AUDIT_CATEGORY.DATABASE;
      const message = error ? `${msg}: ${error.message}` : msg;
      const event = {
        message: `[Privilege Monitoring] ${message}`,
        event: {
          action: `${action}_${resource}`,
          category,
          outcome,
          type
        }
      };
      return auditLogger === null || auditLogger === void 0 ? void 0 : auditLogger.log(event);
    }
  };
};
exports.createPrivMonAuditLogger = createPrivMonAuditLogger;