"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.stopEntityEngineRoute = void 0;
var _utils = require("@kbn/lists-plugin/server/routes/utils");
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _zodHelpers = require("@kbn/zod-helpers");
var _search_strategy = require("../../../../../common/search_strategy");
var _stop = require("../../../../../common/api/entity_analytics/entity_store/engine/stop.gen");
var _constants = require("../../../../../common/constants");
var _constants2 = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const stopEntityEngineRoute = (router, logger) => {
  router.versioned.post({
    access: 'public',
    path: '/api/entity_store/engines/{entityType}/stop',
    security: {
      authz: {
        requiredPrivileges: ['securitySolution', `${_constants.APP_ID}-entity-analytics`]
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: {
        params: (0, _zodHelpers.buildRouteValidationWithZod)(_stop.StopEntityEngineRequestParams)
      }
    }
  }, async (context, request, response) => {
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    try {
      const secSol = await context.securitySolution;
      const engine = await secSol.getEntityStoreDataClient().stop(_search_strategy.EntityType[request.params.entityType]);
      return response.ok({
        body: {
          stopped: engine.status === _constants2.ENGINE_STATUS.STOPPED
        }
      });
    } catch (e) {
      logger.error(`Error in StopEntityEngine: ${e.message}`);
      const error = (0, _securitysolutionEsUtils.transformError)(e);
      return siemResponse.error({
        statusCode: error.statusCode,
        body: error.message
      });
    }
  });
};
exports.stopEntityEngineRoute = stopEntityEngineRoute;