"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.entityStoreInternalPrivilegesRoute = void 0;
var _utils = require("@kbn/lists-plugin/server/routes/utils");
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _constants = require("../../../../../common/entity_analytics/entity_store/constants");
var _constants2 = require("../../../../../common/constants");
var _audit = require("../../audit");
var _utils2 = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const entityStoreInternalPrivilegesRoute = (router, logger, getStartServices) => {
  router.versioned.get({
    access: 'internal',
    path: _constants.ENTITY_STORE_INTERNAL_PRIVILEGES_URL,
    security: {
      authz: {
        requiredPrivileges: ['securitySolution', `${_constants2.APP_ID}-entity-analytics`]
      }
    }
  }).addVersion({
    version: _constants2.API_VERSIONS.internal.v1,
    validate: false
  }, async (context, request, response) => {
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    try {
      var _securitySolution$get;
      const {
        getSpaceId,
        getAppClient,
        getDataViewsService
      } = await context.securitySolution;
      const securitySolution = await context.securitySolution;
      (_securitySolution$get = securitySolution.getAuditLogger()) === null || _securitySolution$get === void 0 ? void 0 : _securitySolution$get.log({
        message: 'User checked if they have the required privileges to use the Entity Store',
        event: {
          action: `entity_store_privilege_get`,
          category: _audit.AUDIT_CATEGORY.AUTHENTICATION,
          type: _audit.AUDIT_TYPE.ACCESS,
          outcome: _audit.AUDIT_OUTCOME.UNKNOWN
        }
      });
      const securitySolutionIndices = await (0, _utils2.buildIndexPatterns)(getSpaceId(), getAppClient(), getDataViewsService());
      const body = await securitySolution.getEntityStoreDataClient().getEntityStoreInitPrivileges(securitySolutionIndices);
      return response.ok({
        body
      });
    } catch (e) {
      const error = (0, _securitysolutionEsUtils.transformError)(e);
      return siemResponse.error({
        statusCode: error.statusCode,
        body: error.message
      });
    }
  });
};
exports.entityStoreInternalPrivilegesRoute = entityStoreInternalPrivilegesRoute;