"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.applyDataViewIndicesEntityEngineRoute = void 0;
var _utils = require("@kbn/lists-plugin/server/routes/utils");
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _constants = require("../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const applyDataViewIndicesEntityEngineRoute = (router, logger) => {
  router.versioned.post({
    access: 'public',
    path: '/api/entity_store/engines/apply_dataview_indices',
    security: {
      authz: {
        requiredPrivileges: ['securitySolution', `${_constants.APP_ID}-entity-analytics`]
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: {}
    }
  }, async (context, _, response) => {
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    try {
      const secSol = await context.securitySolution;
      const {
        errors,
        successes
      } = await secSol.getEntityStoreDataClient().applyDataViewIndices();
      const errorMessages = errors.map(e => e.message);
      if (successes.length === 0 && errors.length > 0) {
        return siemResponse.error({
          statusCode: 500,
          body: `Errors applying data view changes to the entity store. Errors: \n${errorMessages.join('\n\n')}`
        });
      }
      const apiKeyManager = secSol.getEntityStoreApiKeyManager();
      await apiKeyManager.generate();
      if (errors.length === 0) {
        return response.ok({
          body: {
            success: true,
            result: successes
          }
        });
      } else {
        return response.multiStatus({
          body: {
            success: false,
            errors: errorMessages,
            result: successes
          }
        });
      }
    } catch (e) {
      logger.error(`Error in ApplyEntityEngineDataViewIndices: ${e.message}`);
      const error = (0, _securitysolutionEsUtils.transformError)(e);
      return siemResponse.error({
        statusCode: error.statusCode,
        body: error.message
      });
    }
  });
};
exports.applyDataViewIndicesEntityEngineRoute = applyDataViewIndicesEntityEngineRoute;