"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fieldOperatorToIngestProcessor = void 0;
var _prefer_newest_value = require("./prefer_newest_value");
var _prefer_oldest_value = require("./prefer_oldest_value");
var _collect_values = require("./collect_values");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Converts a field retention operator to an ingest processor.
 * An ingest processor is a step that can be added to an ingest pipeline.
 */
const fieldOperatorToIngestProcessor = (field, options) => {
  if (!field.retention) {
    throw new Error('Field retention operator is required');
  }
  switch (field.retention.operation) {
    case 'prefer_newest_value':
      return (0, _prefer_newest_value.preferNewestValueProcessor)(field, options);
    case 'prefer_oldest_value':
      return (0, _prefer_oldest_value.preferOldestValueProcessor)(field, options);
    case 'collect_values':
      return (0, _collect_values.collectValuesProcessor)(field, options);
  }
};
exports.fieldOperatorToIngestProcessor = fieldOperatorToIngestProcessor;