"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createEntityResetIndex = createEntityResetIndex;
exports.deleteEntityResetIndex = deleteEntityResetIndex;
exports.getEntityResetIndexStatus = void 0;
var _entity_analytics = require("../../../../../common/api/entity_analytics");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function createEntityResetIndex({
  entityType,
  esClient,
  namespace
}) {
  return esClient.indices.create({
    index: (0, _utils.getEntitiesResetIndexName)(entityType, namespace)
  });
}
function deleteEntityResetIndex({
  entityType,
  esClient,
  namespace
}) {
  return esClient.indices.delete({
    index: (0, _utils.getEntitiesResetIndexName)(entityType, namespace)
  }, {
    ignore: [404]
  });
}
const getEntityResetIndexStatus = async ({
  entityType,
  esClient,
  namespace
}) => {
  const index = (0, _utils.getEntitiesResetIndexName)(entityType, namespace);
  const exists = await esClient.indices.exists({
    index
  }, {
    ignore: [404]
  });
  return {
    id: index,
    installed: exists,
    resource: _entity_analytics.EngineComponentResourceEnum.index
  };
};
exports.getEntityResetIndexStatus = getEntityResetIndexStatus;