"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.assetCriticalityInternalPrivilegesRoute = void 0;
var _utils = require("@kbn/lists-plugin/server/routes/utils");
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _constants = require("../../../../../common/constants");
var _check_and_init_asset_criticality_resources = require("../check_and_init_asset_criticality_resources");
var _get_user_asset_criticality_privileges = require("../get_user_asset_criticality_privileges");
var _audit = require("../audit");
var _audit2 = require("../../audit");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const assetCriticalityInternalPrivilegesRoute = (router, logger, getStartServices) => {
  router.versioned.get({
    access: 'internal',
    path: _constants.ASSET_CRITICALITY_INTERNAL_PRIVILEGES_URL,
    security: {
      authz: {
        requiredPrivileges: ['securitySolution', `${_constants.APP_ID}-entity-analytics`]
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.internal.v1,
    validate: false
  }, async (context, request, response) => {
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    try {
      var _securitySolution$get;
      await (0, _check_and_init_asset_criticality_resources.checkAndInitAssetCriticalityResources)(context, logger);
      const [_, {
        security
      }] = await getStartServices();
      const body = await (0, _get_user_asset_criticality_privileges.getUserAssetCriticalityPrivileges)(request, security);
      const securitySolution = await context.securitySolution;
      (_securitySolution$get = securitySolution.getAuditLogger()) === null || _securitySolution$get === void 0 ? void 0 : _securitySolution$get.log({
        message: 'User checked if they have the required privileges to use asset criticality',
        event: {
          action: _audit.AssetCriticalityAuditActions.ASSET_CRITICALITY_PRIVILEGE_GET,
          category: _audit2.AUDIT_CATEGORY.AUTHENTICATION,
          type: _audit2.AUDIT_TYPE.ACCESS,
          outcome: _audit2.AUDIT_OUTCOME.UNKNOWN
        }
      });
      return response.ok({
        body
      });
    } catch (e) {
      const error = (0, _securitysolutionEsUtils.transformError)(e);
      return siemResponse.error({
        statusCode: error.statusCode,
        body: error.message
      });
    }
  });
};
exports.assetCriticalityInternalPrivilegesRoute = assetCriticalityInternalPrivilegesRoute;