"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.wrapSuppressedAlerts = void 0;
var _objectHash = _interopRequireDefault(require("object-hash"));
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _transform_hit_to_alert = require("../factories/utils/transform_hit_to_alert");
var _suppression_utils = require("./suppression_utils");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * wraps suppressed alerts
 * creates instanceId hash, which is used to search on time interval alerts
 * populates alert's suppression fields
 */
const wrapSuppressedAlerts = ({
  events,
  buildReasonMessage,
  sharedParams
}) => {
  const {
    completeRule,
    spaceId,
    primaryTimestamp,
    secondaryTimestamp
  } = sharedParams;
  return events.map(event => {
    var _completeRule$rulePar;
    const suppressionTerms = (0, _suppression_utils.getSuppressionTerms)({
      alertSuppression: completeRule === null || completeRule === void 0 ? void 0 : (_completeRule$rulePar = completeRule.ruleParams) === null || _completeRule$rulePar === void 0 ? void 0 : _completeRule$rulePar.alertSuppression,
      input: event.fields
    });
    const id = (0, _utils.generateId)(event._index,
    // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
    event._id, String(event._version), `${spaceId}:${completeRule.alertId}`);
    const instanceId = (0, _objectHash.default)([suppressionTerms, completeRule.alertId, spaceId]);
    const baseAlert = (0, _transform_hit_to_alert.transformHitToAlert)({
      sharedParams,
      doc: event,
      applyOverrides: true,
      buildReasonMessage,
      alertUuid: id
    });
    return {
      _id: id,
      _index: '',
      _source: {
        ...baseAlert,
        ...(0, _suppression_utils.getSuppressionAlertFields)({
          primaryTimestamp,
          secondaryTimestamp,
          fields: event.fields,
          suppressionTerms,
          fallbackTimestamp: baseAlert[_ruleDataUtils.TIMESTAMP],
          instanceId
        })
      }
    };
  });
};
exports.wrapSuppressedAlerts = wrapSuppressedAlerts;