"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.searchAfterAndBulkCreateSuppressedAlerts = void 0;
var _utils = require("./utils");
var _search_after_bulk_create_factory = require("./search_after_bulk_create_factory");
var _bulk_create_suppressed_alerts_in_memory = require("./bulk_create_suppressed_alerts_in_memory");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * search_after through documents and re-index using bulk endpoint
 * and suppress alerts
 */
const searchAfterAndBulkCreateSuppressedAlerts = async params => {
  const {
    sharedParams,
    services,
    buildReasonMessage,
    alertSuppression,
    wrapSuppressedHits
  } = params;
  const bulkCreateExecutor = async ({
    enrichedEvents,
    toReturn
  }) => {
    return (0, _bulk_create_suppressed_alerts_in_memory.bulkCreateSuppressedAlertsInMemory)({
      sharedParams,
      services,
      buildReasonMessage,
      alertSuppression,
      wrapSuppressedHits,
      enrichedEvents,
      toReturn
    });
  };
  return (0, _search_after_bulk_create_factory.searchAfterAndBulkCreateFactory)({
    ...params,
    bulkCreateExecutor,
    getWarningMessage: _utils.getSuppressionMaxSignalsWarning
  });
};
exports.searchAfterAndBulkCreateSuppressedAlerts = searchAfterAndBulkCreateSuppressedAlerts;