"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createEventSignal = void 0;
var _constants = require("../../../../../../common/constants");
var _get_filter = require("../../utils/get_filter");
var _search_after_bulk_create = require("../../utils/search_after_bulk_create");
var _reason_formatters = require("../../utils/reason_formatters");
var _get_signal_id_to_matched_queries_map = require("./get_signal_id_to_matched_queries_map");
var _search_after_bulk_create_suppressed_alerts = require("../../utils/search_after_bulk_create_suppressed_alerts");
var _threat_enrichment_factory = require("./threat_enrichment_factory");
var _utils = require("./utils");
var _get_is_alert_suppression_active = require("../../utils/get_is_alert_suppression_active");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createEventSignal = async ({
  sharedParams,
  currentResult,
  currentEventList,
  eventsTelemetry,
  filters,
  services,
  wrapSuppressedHits,
  threatFilters,
  threatPitId,
  reassignThreatPitId,
  allowedFieldsForTermsQuery,
  inputIndexFields,
  threatIndexFields,
  sortOrder = 'desc',
  isAlertSuppressionActive
}) => {
  var _sharedParams$complet;
  const {
    ruleExecutionLogger,
    exceptionFilter,
    inputIndex,
    completeRule: {
      ruleParams: {
        threatMapping,
        type,
        language,
        query,
        savedId
      }
    }
  } = sharedParams;
  const threatIndicatorPath = (_sharedParams$complet = sharedParams.completeRule.ruleParams.threatIndicatorPath) !== null && _sharedParams$complet !== void 0 ? _sharedParams$complet : _constants.DEFAULT_INDICATOR_SOURCE_PATH;
  let signalIdToMatchedQueriesMap;
  try {
    signalIdToMatchedQueriesMap = await (0, _get_signal_id_to_matched_queries_map.getSignalIdToMatchedQueriesMap)({
      services,
      sharedParams,
      signals: currentEventList,
      allowedFieldsForTermsQuery,
      pitId: threatPitId,
      reassignThreatPitId,
      threatFilters,
      threatIndexFields,
      threatIndicatorPath
    });
  } catch (exc) {
    // we receive an error if the event list count < threat list count
    // which puts us into the create_event_signal which differs from create threat signal
    // in that we call getSignalsQueryMapFromThreatIndex which can *throw* an error
    // rather than *return* one.
    if (exc.message.includes(_utils.MANY_NESTED_CLAUSES_ERR) || exc.message.includes(_utils.FAILED_CREATE_QUERY_MAX_CLAUSE)) {
      currentResult.errors.push(exc.message);
      return currentResult;
    } else {
      throw exc;
    }
  }
  const ids = Array.from(signalIdToMatchedQueriesMap.keys());
  if (ids.length === 0) {
    return currentResult;
  }
  const indexFilter = {
    query: {
      bool: {
        filter: {
          ids: {
            values: ids
          }
        }
      }
    }
  };
  const esFilter = await (0, _get_filter.getFilter)({
    type,
    filters: [...filters, indexFilter],
    language,
    query,
    savedId,
    services,
    index: inputIndex,
    exceptionFilter,
    fields: inputIndexFields,
    loadFields: true
  });
  ruleExecutionLogger.debug(`${ids === null || ids === void 0 ? void 0 : ids.length} matched signals found`);
  const enrichment = (0, _threat_enrichment_factory.threatEnrichmentFactory)({
    signalIdToMatchedQueriesMap,
    threatIndicatorPath,
    threatMappings: threatMapping
  });
  let createResult;
  const searchAfterBulkCreateParams = {
    sharedParams,
    buildReasonMessage: _reason_formatters.buildReasonMessageForThreatMatchAlert,
    enrichment,
    eventsTelemetry,
    filter: esFilter,
    services,
    sortOrder,
    trackTotalHits: false
  };
  if (isAlertSuppressionActive && (0, _get_is_alert_suppression_active.alertSuppressionTypeGuard)(sharedParams.completeRule.ruleParams.alertSuppression)) {
    createResult = await (0, _search_after_bulk_create_suppressed_alerts.searchAfterAndBulkCreateSuppressedAlerts)({
      ...searchAfterBulkCreateParams,
      wrapSuppressedHits,
      alertSuppression: sharedParams.completeRule.ruleParams.alertSuppression
    });
  } else {
    createResult = await (0, _search_after_bulk_create.searchAfterAndBulkCreate)(searchAfterBulkCreateParams);
  }
  ruleExecutionLogger.debug(`${currentEventList.length} items have completed match checks and the total times to search were ${createResult.searchAfterTimes.length !== 0 ? createResult.searchAfterTimes : '(unknown) '}ms`);
  return createResult;
};
exports.createEventSignal = createEventSignal;