"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildThreatEnrichment = void 0;
var _get_signal_id_to_matched_queries_map = require("./get_signal_id_to_matched_queries_map");
var _threat_enrichment_factory = require("./threat_enrichment_factory");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// we do want to make extra requests to the threat index to get enrichments from all threats
// previously we were enriched alerts only from `currentThreatList` but not all threats
const buildThreatEnrichment = ({
  sharedParams,
  services,
  threatFilters,
  threatIndicatorPath,
  pitId,
  reassignThreatPitId,
  threatIndexFields,
  allowedFieldsForTermsQuery,
  threatMapping
}) => {
  return async signals => {
    const signalIdToMatchedQueriesMap = await (0, _get_signal_id_to_matched_queries_map.getSignalIdToMatchedQueriesMap)({
      services,
      sharedParams,
      signals,
      allowedFieldsForTermsQuery,
      pitId,
      reassignThreatPitId,
      threatFilters,
      threatIndexFields,
      threatIndicatorPath
    });
    const enrichment = (0, _threat_enrichment_factory.threatEnrichmentFactory)({
      signalIdToMatchedQueriesMap,
      threatIndicatorPath,
      threatMappings: threatMapping
    });
    return enrichment(signals);
  };
};
exports.buildThreatEnrichment = buildThreatEnrichment;