"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isValidIpType = void 0;
var _ipaddr = require("ipaddr.js");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * validates ES ip type
 */
const isValidIpType = ip => {
  if (typeof ip !== 'string') {
    return false;
  }
  return (0, _ipaddr.isValid)(ip);
};
exports.isValidIpType = isValidIpType;