"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initiateExcludedDocuments = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initiateExcludedDocuments = ({
  state,
  isRuleAggregating,
  tuple,
  hasMvExpand,
  query
}) => {
  // exclude ids from store if mv_expand used and query has changed. this would allow to create alerts from changed mv_expand queries
  if (isRuleAggregating || !(state !== null && state !== void 0 && state.excludedDocuments) || hasMvExpand && query !== state.lastQuery) {
    return {};
  }
  const excludedDocuments = {};
  for (const index of Object.keys(
  // handle a case when excludedDocuments format was array in previous implementation
  // we would discard this array and build a new structure aware of document indices
  Array.isArray(state.excludedDocuments) ? {} : state.excludedDocuments)) {
    var _state$excludedDocume, _state$excludedDocume2, _state$excludedDocume3;
    const indexDocuments = (_state$excludedDocume = state === null || state === void 0 ? void 0 : (_state$excludedDocume2 = state.excludedDocuments) === null || _state$excludedDocume2 === void 0 ? void 0 : (_state$excludedDocume3 = _state$excludedDocume2[index]) === null || _state$excludedDocume3 === void 0 ? void 0 : _state$excludedDocume3.filter(({
      timestamp
    }) => {
      return timestamp && timestamp >= tuple.from.toISOString();
    })) !== null && _state$excludedDocume !== void 0 ? _state$excludedDocume : [];
    if (indexDocuments.length) {
      excludedDocuments[index] = indexDocuments;
    }
  }
  return excludedDocuments;
};
exports.initiateExcludedDocuments = initiateExcludedDocuments;