"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRuleByIdOrRuleId = void 0;
var _invariant = require("../../../../../../../common/utils/invariant");
var _get_rule_by_id = require("./get_rule_by_id");
var _get_rule_by_rule_id = require("./get_rule_by_rule_id");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getRuleByIdOrRuleId = async ({
  rulesClient,
  id,
  ruleId
}) => {
  if (id != null) {
    return (0, _get_rule_by_id.getRuleById)({
      rulesClient,
      id
    });
  }
  if (ruleId != null) {
    return (0, _get_rule_by_rule_id.getRuleByRuleId)({
      rulesClient,
      ruleId
    });
  }
  (0, _invariant.invariant)(false, 'Either id or ruleId must be provided');
};
exports.getRuleByIdOrRuleId = getRuleByIdOrRuleId;