"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRuleById = void 0;
var _convert_alerting_rule_to_rule_response = require("../converters/convert_alerting_rule_to_rule_response");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getRuleById = async ({
  rulesClient,
  id
}) => {
  try {
    const rule = await rulesClient.resolve({
      id
    });
    return (0, _convert_alerting_rule_to_rule_response.convertAlertingRuleToRuleResponse)(rule);
  } catch (err) {
    var _err$output;
    if ((err === null || err === void 0 ? void 0 : (_err$output = err.output) === null || _err$output === void 0 ? void 0 : _err$output.statusCode) === 404) {
      return null;
    }
    throw err;
  }
};
exports.getRuleById = getRuleById;