"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RULE_DEFAULTS = void 0;
exports.applyRuleDefaults = applyRuleDefaults;
exports.setTypeSpecificDefaults = void 0;
var _uuid = require("uuid");
var _object_case_converters = require("../../../../../../utils/object_case_converters");
var _utils = require("../../../../../../../common/detection_engine/rule_management/utils");
var _constants = require("../../../../../../../common/constants");
var _utils2 = require("../../../../../../../common/detection_engine/utils");
var _utility_types = require("../../../../../../../common/utility_types");
var _normalize_rule_source = require("../converters/normalize_rule_source");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RULE_DEFAULTS = exports.RULE_DEFAULTS = {
  enabled: false,
  risk_score_mapping: [],
  severity_mapping: [],
  interval: '5m',
  to: 'now',
  from: 'now-6m',
  exceptions_list: [],
  false_positives: [],
  max_signals: _constants.DEFAULT_MAX_SIGNALS,
  actions: [],
  related_integrations: [],
  required_fields: [],
  setup: '',
  references: [],
  threat: [],
  tags: [],
  author: [],
  output_index: '',
  version: 1
};
function applyRuleDefaults(rule) {
  var _rule$immutable, _rule$rule_id;
  const typeSpecificParams = setTypeSpecificDefaults(rule);
  const immutable = (_rule$immutable = rule.immutable) !== null && _rule$immutable !== void 0 ? _rule$immutable : false;
  return {
    ...RULE_DEFAULTS,
    ...rule,
    ...typeSpecificParams,
    rule_id: (_rule$rule_id = rule.rule_id) !== null && _rule$rule_id !== void 0 ? _rule$rule_id : (0, _uuid.v4)(),
    immutable,
    rule_source: (0, _object_case_converters.convertObjectKeysToSnakeCase)((0, _normalize_rule_source.normalizeRuleSource)({
      immutable,
      ruleSource: rule.rule_source ? (0, _object_case_converters.convertObjectKeysToCamelCase)(rule.rule_source) : undefined
    })),
    required_fields: (0, _utils.addEcsToRequiredFields)(rule.required_fields)
  };
}
const setTypeSpecificDefaults = props => {
  switch (props.type) {
    case 'eql':
      {
        return {
          type: props.type,
          language: props.language,
          index: props.index,
          data_view_id: props.data_view_id,
          query: props.query,
          filters: props.filters,
          timestamp_field: props.timestamp_field,
          event_category_override: props.event_category_override,
          tiebreaker_field: props.tiebreaker_field,
          alert_suppression: props.alert_suppression
        };
      }
    case 'esql':
      {
        return {
          type: props.type,
          language: props.language,
          query: props.query,
          alert_suppression: props.alert_suppression
        };
      }
    case 'threat_match':
      {
        var _props$language, _props$threat_indicat;
        return {
          type: props.type,
          language: (_props$language = props.language) !== null && _props$language !== void 0 ? _props$language : 'kuery',
          index: props.index,
          data_view_id: props.data_view_id,
          query: props.query,
          filters: props.filters,
          saved_id: props.saved_id,
          threat_filters: props.threat_filters,
          threat_query: props.threat_query,
          threat_mapping: props.threat_mapping,
          threat_language: props.threat_language,
          threat_index: props.threat_index,
          threat_indicator_path: (_props$threat_indicat = props.threat_indicator_path) !== null && _props$threat_indicat !== void 0 ? _props$threat_indicat : _constants.DEFAULT_INDICATOR_SOURCE_PATH,
          concurrent_searches: props.concurrent_searches,
          items_per_search: props.items_per_search,
          alert_suppression: props.alert_suppression
        };
      }
    case 'query':
      {
        var _props$language2, _props$query;
        return {
          type: props.type,
          language: (_props$language2 = props.language) !== null && _props$language2 !== void 0 ? _props$language2 : 'kuery',
          index: props.index,
          data_view_id: props.data_view_id,
          query: (_props$query = props.query) !== null && _props$query !== void 0 ? _props$query : '',
          filters: props.filters,
          saved_id: props.saved_id,
          alert_suppression: props.alert_suppression
        };
      }
    case 'saved_query':
      {
        var _props$language3;
        return {
          type: props.type,
          language: (_props$language3 = props.language) !== null && _props$language3 !== void 0 ? _props$language3 : 'kuery',
          index: props.index,
          query: props.query,
          filters: props.filters,
          saved_id: props.saved_id,
          data_view_id: props.data_view_id,
          alert_suppression: props.alert_suppression
        };
      }
    case 'threshold':
      {
        var _props$language4, _props$alert_suppress;
        return {
          type: props.type,
          language: (_props$language4 = props.language) !== null && _props$language4 !== void 0 ? _props$language4 : 'kuery',
          index: props.index,
          data_view_id: props.data_view_id,
          query: props.query,
          filters: props.filters,
          saved_id: props.saved_id,
          threshold: (0, _utils2.normalizeThresholdObject)(props.threshold),
          alert_suppression: (_props$alert_suppress = props.alert_suppression) !== null && _props$alert_suppress !== void 0 && _props$alert_suppress.duration ? {
            duration: props.alert_suppression.duration
          } : undefined
        };
      }
    case 'machine_learning':
      {
        return {
          type: props.type,
          anomaly_threshold: props.anomaly_threshold,
          machine_learning_job_id: (0, _utils2.normalizeMachineLearningJobIds)(props.machine_learning_job_id),
          alert_suppression: props.alert_suppression
        };
      }
    case 'new_terms':
      {
        var _props$language5;
        return {
          type: props.type,
          query: props.query,
          new_terms_fields: props.new_terms_fields,
          history_window_start: props.history_window_start,
          index: props.index,
          filters: props.filters,
          language: (_props$language5 = props.language) !== null && _props$language5 !== void 0 ? _props$language5 : 'kuery',
          data_view_id: props.data_view_id,
          alert_suppression: props.alert_suppression
        };
      }
    default:
      {
        return (0, _utility_types.assertUnreachable)(props);
      }
  }
};
exports.setTypeSpecificDefaults = setTypeSpecificDefaults;