"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertPrebuiltRuleAssetToRuleResponse = void 0;
var _uuid = require("uuid");
var _rule_schema = require("../../../../../../../common/api/detection_engine/model/rule_schema");
var _apply_rule_defaults = require("../mergers/apply_rule_defaults");
var _create_default_external_rule_source = require("../mergers/rule_source/create_default_external_rule_source");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const convertPrebuiltRuleAssetToRuleResponse = prebuiltRuleAsset => {
  const immutable = true;
  const ruleResponseSpecificFields = {
    id: (0, _uuid.v4)(),
    updated_at: new Date().toISOString(),
    updated_by: '',
    created_at: new Date().toISOString(),
    created_by: '',
    immutable,
    rule_source: (0, _create_default_external_rule_source.createDefaultExternalRuleSource)(),
    revision: 1
  };
  const ruleWithDefaults = (0, _apply_rule_defaults.applyRuleDefaults)(prebuiltRuleAsset);
  return _rule_schema.RuleResponse.parse({
    ...ruleWithDefaults,
    ...ruleResponseSpecificFields
  });
};
exports.convertPrebuiltRuleAssetToRuleResponse = convertPrebuiltRuleAssetToRuleResponse;