"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.exportRulesRoute = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _zodHelpers = require("@kbn/zod-helpers");
var _constants = require("../../../../../../../common/constants");
var _rule_management = require("../../../../../../../common/api/detection_engine/rule_management");
var _get_existing_prepackaged_rules = require("../../../logic/search/get_existing_prepackaged_rules");
var _get_export_by_object_ids = require("../../../logic/export/get_export_by_object_ids");
var _get_export_all = require("../../../logic/export/get_export_all");
var _utils = require("../../../../routes/utils");
var _timeouts = require("../../timeouts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const exportRulesRoute = (router, config, logger) => {
  router.versioned.post({
    access: 'public',
    path: `${_constants.DETECTION_ENGINE_RULES_URL}/_export`,
    security: {
      authz: {
        requiredPrivileges: ['securitySolution']
      }
    },
    options: {
      timeout: {
        idleSocket: _timeouts.RULE_MANAGEMENT_IMPORT_EXPORT_SOCKET_TIMEOUT_MS
      }
    }
  }).addVersion({
    version: '2023-10-31',
    validate: {
      request: {
        query: (0, _zodHelpers.buildRouteValidationWithZod)(_rule_management.ExportRulesRequestQuery),
        body: (0, _zodHelpers.buildRouteValidationWithZod)(_rule_management.ExportRulesRequestBody)
      }
    }
  }, async (context, request, response) => {
    var _ctx$lists;
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    const ctx = await context.resolve(['core', 'securitySolution', 'alerting', 'actions', 'lists']);
    const rulesClient = await ctx.alerting.getRulesClient();
    const exceptionsClient = (_ctx$lists = ctx.lists) === null || _ctx$lists === void 0 ? void 0 : _ctx$lists.getExceptionListClient();
    const actionsClient = ctx.actions.getActionsClient();
    const {
      getExporter,
      getClient
    } = ctx.core.savedObjects;
    const client = getClient({
      includedHiddenTypes: ['action']
    });
    const actionsExporter = getExporter(client);
    try {
      var _request$body, _request$body2;
      const exportSizeLimit = config.maxRuleImportExportSize;
      if (((_request$body = request.body) === null || _request$body === void 0 ? void 0 : _request$body.objects) != null && request.body.objects.length > exportSizeLimit) {
        return siemResponse.error({
          statusCode: 400,
          body: `Can't export more than ${exportSizeLimit} rules`
        });
      } else {
        const rulesCount = await (0, _get_existing_prepackaged_rules.getRulesCount)({
          rulesClient,
          filter: ''
        });
        if (rulesCount > exportSizeLimit) {
          return siemResponse.error({
            statusCode: 400,
            body: `Can't export more than ${exportSizeLimit} rules`
          });
        }
      }
      const exportedRulesAndReferences = ((_request$body2 = request.body) === null || _request$body2 === void 0 ? void 0 : _request$body2.objects) != null ? await (0, _get_export_by_object_ids.getExportByObjectIds)(rulesClient, exceptionsClient, request.body.objects.map(obj => obj.rule_id), actionsExporter, request, actionsClient) : await (0, _get_export_all.getExportAll)(rulesClient, exceptionsClient, actionsExporter, request, actionsClient);
      const responseBody = request.query.exclude_export_details ? exportedRulesAndReferences.rulesNdjson : `${exportedRulesAndReferences.rulesNdjson}${exportedRulesAndReferences.exceptionLists}${exportedRulesAndReferences.actionConnectors}${exportedRulesAndReferences.exportDetails}`;
      return response.ok({
        headers: {
          'Content-Disposition': `attachment; filename="${request.query.file_name}"`,
          'Content-Type': 'application/ndjson'
        },
        body: responseBody
      });
    } catch (err) {
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      return siemResponse.error({
        body: error.message,
        statusCode: error.statusCode
      });
    }
  });
};
exports.exportRulesRoute = exportRulesRoute;