"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateAlertTagsArrays = exports.validateAlertAssigneesArrays = void 0;
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const validateAlertTagsArrays = (tags, ids) => {
  const validationErrors = [];
  if (ids.length === 0) {
    validationErrors.push(i18n.NO_IDS_VALIDATION_ERROR);
  }
  const {
    tags_to_add: tagsToAdd,
    tags_to_remove: tagsToRemove
  } = tags;
  const duplicates = tagsToAdd.filter(tag => tagsToRemove.includes(tag));
  if (duplicates.length) {
    validationErrors.push(i18n.ALERT_TAGS_VALIDATION_ERROR(JSON.stringify(duplicates)));
  }
  return validationErrors;
};
exports.validateAlertTagsArrays = validateAlertTagsArrays;
const validateAlertAssigneesArrays = assignees => {
  const validationErrors = [];
  const {
    add: assigneesToAdd,
    remove: assigneesToRemove
  } = assignees;
  const duplicates = assigneesToAdd.filter(assignee => assigneesToRemove.includes(assignee));
  if (duplicates.length) {
    validationErrors.push(i18n.ALERT_ASSIGNEES_VALIDATION_ERROR(JSON.stringify(duplicates)));
  }
  return validationErrors;
};
exports.validateAlertAssigneesArrays = validateAlertAssigneesArrays;