"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchRuleVersionsTriad = fetchRuleVersionsTriad;
var _get_existing_prepackaged_rules = require("../../../rule_management/logic/search/get_existing_prepackaged_rules");
var _zip_rule_versions = require("./zip_rule_versions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function fetchRuleVersionsTriad({
  ruleObjectsClient,
  ruleAssetsClient,
  versionSpecifiers,
  filter
}) {
  const [currentRules, latestRules] = await Promise.all([versionSpecifiers ? ruleObjectsClient.fetchInstalledRulesByIds({
    ruleIds: versionSpecifiers.map(({
      rule_id: ruleId
    }) => ruleId)
  }) : ruleObjectsClient.fetchInstalledRules({
    filter,
    page: 1,
    perPage: _get_existing_prepackaged_rules.MAX_PREBUILT_RULES_COUNT
  }), versionSpecifiers ? ruleAssetsClient.fetchAssetsByVersion(versionSpecifiers) : ruleAssetsClient.fetchLatestAssets()]);
  const baseRules = await ruleAssetsClient.fetchAssetsByVersion(currentRules);
  return (0, _zip_rule_versions.zipRuleVersions)(currentRules, baseRules, latestRules);
}