"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.reviewRuleInstallationHandler = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _utils = require("../../../routes/utils");
var _convert_prebuilt_rule_asset_to_rule_response = require("../../../rule_management/logic/detection_rules_client/converters/convert_prebuilt_rule_asset_to_rule_response");
var _prebuilt_rule_assets_client = require("../../logic/rule_assets/prebuilt_rule_assets_client");
var _prebuilt_rule_objects_client = require("../../logic/rule_objects/prebuilt_rule_objects_client");
var _utils2 = require("../../logic/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const reviewRuleInstallationHandler = async (context, request, response) => {
  const siemResponse = (0, _utils.buildSiemResponse)(response);
  try {
    const ctx = await context.resolve(['core', 'alerting', 'securitySolution']);
    const soClient = ctx.core.savedObjects.client;
    const rulesClient = await ctx.alerting.getRulesClient();
    const ruleAssetsClient = (0, _prebuilt_rule_assets_client.createPrebuiltRuleAssetsClient)(soClient);
    const ruleObjectsClient = (0, _prebuilt_rule_objects_client.createPrebuiltRuleObjectsClient)(rulesClient);
    const mlAuthz = ctx.securitySolution.getMlAuthz();
    const allLatestVersions = await ruleAssetsClient.fetchLatestVersions();
    const currentRuleVersions = await ruleObjectsClient.fetchInstalledRuleVersions();
    const currentRuleVersionsMap = new Map(currentRuleVersions.map(version => [version.rule_id, version]));
    const allInstallableRules = allLatestVersions.filter(latestVersion => !currentRuleVersionsMap.has(latestVersion.rule_id));
    const nonInstalledRuleAssets = await ruleAssetsClient.fetchAssetsByVersion(allInstallableRules);
    const installableRuleAssets = await (0, _utils2.excludeLicenseRestrictedRules)(nonInstalledRuleAssets, mlAuthz);
    const body = {
      stats: calculateRuleStats(installableRuleAssets),
      rules: installableRuleAssets.map(prebuiltRuleAsset => (0, _convert_prebuilt_rule_asset_to_rule_response.convertPrebuiltRuleAssetToRuleResponse)(prebuiltRuleAsset))
    };
    return response.ok({
      body
    });
  } catch (err) {
    const error = (0, _securitysolutionEsUtils.transformError)(err);
    return siemResponse.error({
      body: error.message,
      statusCode: error.statusCode
    });
  }
};
exports.reviewRuleInstallationHandler = reviewRuleInstallationHandler;
const getAggregatedTags = rules => {
  const set = new Set(rules.flatMap(rule => rule.tags || []));
  return Array.from(set.values()).sort((a, b) => a.localeCompare(b));
};
const calculateRuleStats = rulesToInstall => {
  const tagsOfRulesToInstall = getAggregatedTags(rulesToInstall);
  return {
    num_rules_to_install: rulesToInstall.length,
    tags: tagsOfRulesToInstall
  };
};