"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.filterOutNonRevertableRules = void 0;
var _utils = require("../../../../../../common/api/detection_engine/model/rule_schema/utils");
var _detection_engine = require("../../../../../../common/api/detection_engine");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const filterOutNonRevertableRules = rules => {
  const skipped = [];
  const rulesToRevert = rules.filter(rule => {
    if ((0, _utils.isCustomizedPrebuiltRule)(rule)) {
      return true;
    }
    if ((0, _utils.isNonCustomizedPrebuiltRule)(rule)) {
      skipped.push({
        id: rule.id,
        skip_reason: _detection_engine.BulkRevertSkipReasonEnum.RULE_NOT_CUSTOMIZED
      });
      return false;
    }
    skipped.push({
      id: rule.id,
      skip_reason: _detection_engine.BulkRevertSkipReasonEnum.RULE_NOT_PREBUILT
    });
    return false;
  });
  return {
    rulesToRevert,
    skipped
  };
};
exports.filterOutNonRevertableRules = filterOutNonRevertableRules;