"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getValueForField = void 0;
var _create_field_upgrade_specifier = require("./create_field_upgrade_specifier");
var _diffable_rule_fields_mappings = require("./diffable_rule_fields_mappings");
var _get_field_predefined_value = require("./get_field_predefined_value");
var _get_value_from_rule_version = require("./get_value_from_rule_version");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getValueForField = ({
  fieldName,
  upgradeableRule,
  globalPickVersion,
  requestBody,
  ruleFieldsDiff
}) => {
  const fieldStatus = (0, _get_field_predefined_value.getFieldPredefinedValue)(fieldName, upgradeableRule);
  if (fieldStatus.type === 'PREDEFINED_VALUE') {
    return fieldStatus.value;
  }
  if (requestBody.mode === 'ALL_RULES') {
    return globalPickVersion === 'MERGED' ? (0, _get_value_from_rule_version.getValueFromMergedVersion)({
      fieldName,
      upgradeableRule,
      fieldUpgradeSpecifier: {
        pick_version: globalPickVersion
      },
      ruleFieldsDiff,
      onConflict: requestBody.on_conflict
    }) : (0, _get_value_from_rule_version.getValueFromRuleTriad)({
      fieldName,
      upgradeableRule,
      fieldUpgradeSpecifier: {
        pick_version: globalPickVersion
      }
    });
  }

  // Handle SPECIFIC_RULES mode
  const ruleUpgradeSpecifier = requestBody.rules.find(r => r.rule_id === upgradeableRule.target.rule_id);
  if (!ruleUpgradeSpecifier) {
    throw new Error(`Rule payload for upgradable rule ${upgradeableRule.target.rule_id} not found`);
  }
  const fieldUpgradeSpecifier = (0, _create_field_upgrade_specifier.createFieldUpgradeSpecifier)({
    fieldName,
    ruleUpgradeSpecifier,
    targetRuleType: upgradeableRule.target.type,
    globalPickVersion
  });
  if (fieldUpgradeSpecifier.pick_version === 'RESOLVED') {
    const resolvedValue = fieldUpgradeSpecifier.resolved_value;
    return (0, _diffable_rule_fields_mappings.mapDiffableRuleFieldValueToRuleSchemaFormat)(fieldName, resolvedValue);
  }
  return fieldUpgradeSpecifier.pick_version === 'MERGED' ? (0, _get_value_from_rule_version.getValueFromMergedVersion)({
    fieldName,
    upgradeableRule,
    fieldUpgradeSpecifier,
    ruleFieldsDiff,
    onConflict: requestBody.on_conflict
  }) : (0, _get_value_from_rule_version.getValueFromRuleTriad)({
    fieldName,
    upgradeableRule,
    fieldUpgradeSpecifier
  });
};
exports.getValueForField = getValueForField;