"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.type = exports.signalsMigrationType = exports.signalsMigrationMappings = void 0;
var _coreSavedObjectsServer = require("@kbn/core-saved-objects-server");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const signalsMigrationType = exports.signalsMigrationType = 'security-solution-signals-migration';
const signalsMigrationMappings = exports.signalsMigrationMappings = {
  dynamic: false,
  properties: {
    sourceIndex: {
      type: 'keyword'
    },
    updated: {
      type: 'date'
    },
    version: {
      type: 'long'
    }
  }
};
const type = exports.type = {
  name: signalsMigrationType,
  indexPattern: _coreSavedObjectsServer.SECURITY_SOLUTION_SAVED_OBJECT_INDEX,
  hidden: false,
  namespaceType: 'single',
  mappings: signalsMigrationMappings
};