"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseEntityStoreAggs = exports.getEntityStoreStats = void 0;
var _helper = require("../helper");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Parses aggregation buckets into a simplified list of entity stats.
 */
const parseEntityStoreAggs = response => {
  return response.buckets.map(bucket => ({
    entity_store: bucket.key,
    doc_count: bucket.doc_count,
    last_doc_timestamp: bucket.last_doc_timestamp.value_as_string
  }));
};

/**
 * Queries Elasticsearch for entity type stats, parses, and returns them.
 */
exports.parseEntityStoreAggs = parseEntityStoreAggs;
const getEntityStoreStats = async (esClient, logger) => {
  try {
    var _entityStoreStats$agg, _entityStoreStats$agg2, _entityStoreStats$agg3;
    const isIndexExists = await esClient.indices.exists({
      index: _helper.ENTITY_INDEX
    });
    if (!isIndexExists) {
      logger.debug(`Index ${_helper.ENTITY_INDEX} does not exist.`);
      return [];
    }
    const entityStoreStats = await esClient.search((0, _helper.getAggsQuery)('entity.EngineMetadata.Type', 5));
    const buckets = (_entityStoreStats$agg = (_entityStoreStats$agg2 = entityStoreStats.aggregations) === null || _entityStoreStats$agg2 === void 0 ? void 0 : (_entityStoreStats$agg3 = _entityStoreStats$agg2.field_terms) === null || _entityStoreStats$agg3 === void 0 ? void 0 : _entityStoreStats$agg3.buckets) !== null && _entityStoreStats$agg !== void 0 ? _entityStoreStats$agg : [];
    return parseEntityStoreAggs({
      buckets
    });
  } catch (e) {
    logger.error(`Failed to get entity store stats: ${e instanceof Error ? e.message : String(e)}`);
    return [];
  }
};
exports.getEntityStoreStats = getEntityStoreStats;