"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getNlToEsqlAgentWithoutValidation = void 0;
var _rxjs = require("rxjs");
var _server = require("@kbn/inference-plugin/server");
var _langgraph = require("@langchain/langgraph");
var _from_inference = require("@kbn/inference-langchain/src/chat_model/from_inference");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getNlToEsqlAgentWithoutValidation = ({
  connectorId,
  inference,
  logger,
  request
}) => {
  return async state => {
    const {
      input
    } = state;
    if (!input) {
      throw new Error('Input is required');
    }
    const result = await (0, _rxjs.lastValueFrom)((0, _server.naturalLanguageToEsql)({
      client: inference.getClient({
        request
      }),
      connectorId,
      logger,
      input: input.question,
      system: "Just produce the query fenced by the esql tag. Don't explain it."
    }));
    return new _langgraph.Command({
      update: {
        messages: [(0, _from_inference.responseToLangchainMessage)(result)]
      }
    });
  };
};
exports.getNlToEsqlAgentWithoutValidation = getNlToEsqlAgentWithoutValidation;