"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFieldsListCreationOptions = void 0;
var _i18n = require("@kbn/i18n");
var _unifiedFieldList = require("@kbn/unified-field-list");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// This is passed to the unified components container to initialize the field list on the left side of the view
const getFieldsListCreationOptions = () => {
  return {
    originatingApp: 'security_solution',
    localStorageKeyPrefix: 'securitySolution',
    timeRangeUpdatesType: 'timefilter',
    compressed: true,
    showSidebarToggleButton: true,
    disablePopularFields: false,
    buttonAddFieldToWorkspaceProps: {
      'aria-label': _i18n.i18n.translate('xpack.securitySolution.fieldChooser.timelineField.addFieldTooltip', {
        defaultMessage: 'Add field as column'
      })
    },
    buttonRemoveFieldFromWorkspaceProps: {
      'aria-label': _i18n.i18n.translate('xpack.securitySolution.timeline.fieldChooser.timelineField.removeFieldTooltip', {
        defaultMessage: 'Remove field from table'
      })
    },
    onOverrideFieldGroupDetails: groupName => {
      if (groupName === _unifiedFieldList.FieldsGroupNames.AvailableFields) {
        return {
          helpText: _i18n.i18n.translate('xpack.securitySolution.timeline.fieldChooser.availableFieldsTooltip', {
            defaultMessage: 'Fields available for display in the table.'
          })
        };
      }
    },
    dataTestSubj: {
      fieldListAddFieldButtonTestSubj: 'dataView-add-field_btn',
      fieldListSidebarDataTestSubj: 'timeline-sidebar',
      fieldListItemStatsDataTestSubj: 'dscFieldStats',
      fieldListItemDndDataTestSubjPrefix: 'dscFieldListPanelField',
      fieldListItemPopoverDataTestSubj: 'timelineFieldListPanelPopover',
      fieldListItemPopoverHeaderDataTestSubjPrefix: 'timelineFieldListPanel'
    }
  };
};
exports.getFieldsListCreationOptions = getFieldsListCreationOptions;