"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTimelineSelectAlertsOnlyDataView = void 0;
var _react = require("react");
var _use_select_data_view = require("../../../../../../data_view_manager/hooks/use_select_data_view");
var _constants = require("../../../../../../../common/constants");
var _use_space_id = require("../../../../../../common/hooks/use_space_id");
var _constants2 = require("../../../../../../data_view_manager/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns a callback to select the alerts-only data view for the timeline
 */
const useTimelineSelectAlertsOnlyDataView = () => {
  const selectDataView = (0, _use_select_data_view.useSelectDataView)();
  const spaceId = (0, _use_space_id.useSpaceId)();
  return (0, _react.useCallback)(() => selectDataView({
    id: `${_constants.DEFAULT_ALERT_DATA_VIEW_ID}-${spaceId}`,
    scope: _constants2.DataViewManagerScopeName.timeline
  }), [selectDataView, spaceId]);
};
exports.useTimelineSelectAlertsOnlyDataView = useTimelineSelectAlertsOnlyDataView;