"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.PinnedTabContentComponent = void 0;
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _expandableFlyout = require("@kbn/expandable-flyout");
var _containers = require("../../../../../sourcerer/containers");
var _use_data_view = require("../../../../../data_view_manager/hooks/use_data_view");
var _use_selected_patterns = require("../../../../../data_view_manager/hooks/use_selected_patterns");
var _use_fetch_notes = require("../../../../../notes/hooks/use_fetch_notes");
var _panel_keys = require("../../../../../flyout/document_details/shared/constants/panel_keys");
var _kibana = require("../../../../../common/lib/kibana");
var _store = require("../../../../store");
var _containers2 = require("../../../../containers");
var _default_config = require("../../../../../detections/components/alerts_table/default_config");
var _model = require("../../../../../sourcerer/store/model");
var _defaults = require("../../../../store/defaults");
var _use_experimental_features = require("../../../../../common/hooks/use_experimental_features");
var _timeline = require("../../../../../../common/types/timeline");
var _unified_timeline_body = require("../../body/unified_timeline_body");
var _use_timeline_columns = require("../shared/use_timeline_columns");
var _use_timeline_control_columns = require("../shared/use_timeline_control_columns");
var _left = require("../../../../../flyout/document_details/left");
var _use_notes_in_flyout = require("../../properties/use_notes_in_flyout");
var _notes_flyout = require("../../properties/notes_flyout");
var _telemetry = require("../../../../../common/lib/telemetry");
var _default_headers = require("../../body/column_headers/default_headers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/timeline/tabs/pinned/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const rowDetailColumn = [{
  id: 'row-details',
  columnHeaderType: 'not-filtered',
  width: 0,
  headerCellRender: () => null,
  rowCellRender: () => null
}];
const PinnedTabContentComponent = ({
  columns,
  timelineId,
  itemsPerPage,
  itemsPerPageOptions,
  pinnedEventIds,
  rowRenderers,
  sort,
  eventIdToNoteIds
}) => {
  /*
   * Needs to be maintained for each table in each tab independently
   * and consequently it cannot be the part of common redux state
   * of the timeline.
   *
   */
  const [pageIndex, setPageIndex] = (0, _react.useState)(0);
  const {
    telemetry
  } = (0, _kibana.useKibana)().services;
  const {
    newDataViewPickerEnabled
  } = (0, _use_experimental_features.useEnableExperimental)();
  const {
    dataViewId: oldDataViewId,
    sourcererDataView: oldSourcererDataViewSpec,
    selectedPatterns: oldSelectedPatterns
  } = (0, _containers.useSourcererDataView)(_model.SourcererScopeName.timeline);
  const experimentalSelectedPatterns = (0, _use_selected_patterns.useSelectedPatterns)(_model.SourcererScopeName.timeline);
  const {
    dataView: experimentalDataView
  } = (0, _use_data_view.useDataView)(_model.SourcererScopeName.timeline);
  const selectedPatterns = (0, _react.useMemo)(() => newDataViewPickerEnabled ? experimentalSelectedPatterns : oldSelectedPatterns, [experimentalSelectedPatterns, newDataViewPickerEnabled, oldSelectedPatterns]);
  const dataViewId = (0, _react.useMemo)(() => {
    var _experimentalDataView;
    return newDataViewPickerEnabled ? (_experimentalDataView = experimentalDataView.id) !== null && _experimentalDataView !== void 0 ? _experimentalDataView : '' : oldDataViewId;
  }, [experimentalDataView.id, newDataViewPickerEnabled, oldDataViewId]);
  const runtimeMappings = (0, _react.useMemo)(() => newDataViewPickerEnabled ? experimentalDataView.getRuntimeMappings() : oldSourcererDataViewSpec === null || oldSourcererDataViewSpec === void 0 ? void 0 : oldSourcererDataViewSpec.runtimeFieldMap, [experimentalDataView, newDataViewPickerEnabled, oldSourcererDataViewSpec]);
  const filterQuery = (0, _react.useMemo)(() => {
    if ((0, _fp.isEmpty)(pinnedEventIds)) {
      return '';
    }
    const filterObj = Object.entries(pinnedEventIds).reduce((acc, [pinnedId, isPinned]) => {
      if (isPinned) {
        return {
          ...acc,
          bool: {
            ...acc.bool,
            should: [...acc.bool.should, {
              match_phrase: {
                _id: pinnedId
              }
            }]
          }
        };
      }
      return acc;
    }, {
      bool: {
        should: [],
        minimum_should_match: 1
      }
    });
    try {
      return JSON.stringify(filterObj);
    } catch {
      return '';
    }
  }, [pinnedEventIds]);
  const timelineQueryFields = (0, _react.useMemo)(() => {
    const columnsHeader = (0, _fp.isEmpty)(columns) ? _default_headers.defaultUdtHeaders : columns;
    const columnFields = columnsHeader.map(c => c.id);
    return [...columnFields, ..._default_config.requiredFieldsForActions];
  }, [columns]);
  const timelineQuerySortField = (0, _react.useMemo)(() => sort.map(({
    columnId,
    columnType,
    esTypes,
    sortDirection
  }) => ({
    field: columnId,
    type: columnType,
    direction: sortDirection,
    esTypes: esTypes !== null && esTypes !== void 0 ? esTypes : []
  })), [sort]);
  const {
    augmentedColumnHeaders
  } = (0, _use_timeline_columns.useTimelineColumns)(columns);
  const [queryLoadingState, {
    events,
    totalCount,
    loadNextBatch,
    refreshedAt,
    refetch
  }] = (0, _containers2.useTimelineEvents)({
    endDate: '',
    id: `pinned-${timelineId}`,
    indexNames: selectedPatterns,
    dataViewId: dataViewId !== null && dataViewId !== void 0 ? dataViewId : '',
    fields: timelineQueryFields,
    limit: itemsPerPage,
    filterQuery,
    runtimeMappings,
    skip: filterQuery === '',
    startDate: '',
    sort: timelineQuerySortField,
    timerangeKind: undefined
  });
  const {
    onLoad: loadNotesOnEventsLoad
  } = (0, _use_fetch_notes.useFetchNotes)();
  (0, _react.useEffect)(() => {
    // This useEffect loads the notes only for the events on the current
    // page.
    const eventsOnCurrentPage = events.slice(itemsPerPage * pageIndex, itemsPerPage * (pageIndex + 1));
    if (eventsOnCurrentPage.length > 0) {
      loadNotesOnEventsLoad(eventsOnCurrentPage);
    }
  }, [events, pageIndex, itemsPerPage, loadNotesOnEventsLoad]);

  /**
   *
   * Triggers on Datagrid page change
   *
   */
  const onUpdatePageIndex = (0, _react.useCallback)(newPageIndex => setPageIndex(newPageIndex), []);
  const {
    openFlyout
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const securitySolutionNotesDisabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('securitySolutionNotesDisabled');
  const {
    associateNote,
    notes,
    isNotesFlyoutVisible,
    closeNotesFlyout,
    showNotesFlyout,
    eventId: noteEventId,
    setNotesEventId
  } = (0, _use_notes_in_flyout.useNotesInFlyout)({
    eventIdToNoteIds,
    refetch,
    timelineId,
    activeTab: _timeline.TimelineTabs.pinned
  });
  const onToggleShowNotes = (0, _react.useCallback)(eventId => {
    const indexName = selectedPatterns.join(',');
    if (eventId && !securitySolutionNotesDisabled) {
      openFlyout({
        right: {
          id: _panel_keys.DocumentDetailsRightPanelKey,
          params: {
            id: eventId,
            indexName,
            scopeId: timelineId
          }
        },
        left: {
          id: _panel_keys.DocumentDetailsLeftPanelKey,
          path: {
            tab: _left.LeftPanelNotesTab
          },
          params: {
            id: eventId,
            indexName,
            scopeId: timelineId
          }
        }
      });
      telemetry.reportEvent(_telemetry.NotesEventTypes.OpenNoteInExpandableFlyoutClicked, {
        location: timelineId
      });
      telemetry.reportEvent(_telemetry.DocumentEventTypes.DetailsFlyoutOpened, {
        location: timelineId,
        panel: 'left'
      });
    } else {
      if (eventId) {
        setNotesEventId(eventId);
        showNotesFlyout();
      }
    }
  }, [openFlyout, securitySolutionNotesDisabled, selectedPatterns, telemetry, timelineId, setNotesEventId, showNotesFlyout]);
  const leadingControlColumns = (0, _use_timeline_control_columns.useTimelineControlColumn)({
    timelineId,
    refetch,
    events,
    pinnedEventIds,
    eventIdToNoteIds,
    onToggleShowNotes
  });
  const NotesFlyoutMemo = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement(_notes_flyout.NotesFlyout, {
      associateNote: associateNote,
      eventId: noteEventId,
      show: isNotesFlyoutVisible,
      notes: notes,
      onClose: closeNotesFlyout,
      onCancel: closeNotesFlyout,
      timelineId: timelineId,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 291,
        columnNumber: 7
      }
    });
  }, [associateNote, closeNotesFlyout, isNotesFlyoutVisible, noteEventId, notes, timelineId]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, NotesFlyoutMemo, /*#__PURE__*/_react.default.createElement(_unified_timeline_body.UnifiedTimelineBody, {
    header: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null),
    columns: augmentedColumnHeaders,
    rowRenderers: rowRenderers,
    timelineId: timelineId,
    itemsPerPage: itemsPerPage,
    itemsPerPageOptions: itemsPerPageOptions,
    sort: sort,
    events: events,
    refetch: refetch,
    dataLoadingState: queryLoadingState,
    totalCount: totalCount,
    onFetchMoreRecords: loadNextBatch,
    activeTab: _timeline.TimelineTabs.pinned,
    updatedAt: refreshedAt,
    isTextBasedQuery: false,
    leadingControlColumns: leadingControlColumns,
    trailingControlColumns: rowDetailColumn,
    onUpdatePageIndex: onUpdatePageIndex,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 306,
      columnNumber: 7
    }
  }));
};
exports.PinnedTabContentComponent = PinnedTabContentComponent;
const makeMapStateToProps = () => {
  const getTimeline = _store.timelineSelectors.getTimelineByIdSelector();
  const mapStateToProps = (state, {
    timelineId
  }) => {
    var _getTimeline;
    const timeline = (_getTimeline = getTimeline(state, timelineId)) !== null && _getTimeline !== void 0 ? _getTimeline : _defaults.timelineDefaults;
    const {
      columns,
      itemsPerPage,
      itemsPerPageOptions,
      pinnedEventIds,
      sort,
      eventIdToNoteIds
    } = timeline;
    return {
      columns,
      timelineId,
      itemsPerPage,
      itemsPerPageOptions,
      pinnedEventIds,
      sort,
      eventIdToNoteIds
    };
  };
  return mapStateToProps;
};
const connector = (0, _reactRedux.connect)(makeMapStateToProps);
const PinnedTabContent = exports.default = connector(/*#__PURE__*/(0, _react.memo)(PinnedTabContentComponent, (prevProps, nextProps) => prevProps.itemsPerPage === nextProps.itemsPerPage && prevProps.timelineId === nextProps.timelineId && (0, _fastDeepEqual.default)(prevProps.columns, nextProps.columns) && (0, _fastDeepEqual.default)(prevProps.eventIdToNoteIds, nextProps.eventIdToNoteIds) && (0, _fastDeepEqual.default)(prevProps.itemsPerPageOptions, nextProps.itemsPerPageOptions) && (0, _fastDeepEqual.default)(prevProps.pinnedEventIds, nextProps.pinnedEventIds) && (0, _fastDeepEqual.default)(prevProps.sort, nextProps.sort)));

// eslint-disable-next-line import/no-default-export