"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TabsContent = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _use_esql_availability = require("../../../../common/hooks/esql/use_esql_availability");
var _timeline = require("../../../../../common/types/timeline");
var _timeline2 = require("../../../../../common/api/timeline");
var _use_selector = require("../../../../common/hooks/use_selector");
var _use_timeline_events_count = require("../../../../common/hooks/use_timeline_events_count");
var _store = require("../../../store");
var _selectors = require("./selectors");
var i18n = _interopRequireWildcard(require("./translations"));
var _actions = require("../../../store/actions");
var _selectors2 = require("../../../store/selectors");
var _notes = require("../../../../notes");
var _user_privileges = require("../../../../common/components/user_privileges");
var _lazy_timeline_tab_renderer = require("./lazy_timeline_tab_renderer");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/timeline/tabs/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * A HOC which supplies React.Suspense with a fallback component
 * @param Component A component deferred by `React.lazy`
 * @param fallback A fallback component to render while things load. Default is EuiSekeleton for all tabs
 */
const tabWithSuspense = (Component, fallback = /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
  lines: 10,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 52,
    columnNumber: 35
  }
})) => {
  var _Component$displayNam;
  const Comp = /*#__PURE__*/_react.default.forwardRef((props, ref) => /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: fallback,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(Component, (0, _extends2.default)({}, props, {
    ref: ref,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 7
    }
  }))));
  Comp.displayName = `${(_Component$displayNam = Component.displayName) !== null && _Component$displayNam !== void 0 ? _Component$displayNam : 'Tab'}WithSuspense`;
  return Comp;
};
const QueryTab = tabWithSuspense(/*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./query')))), /*#__PURE__*/_react.default.createElement(_lazy_timeline_tab_renderer.TimelineTabFallback, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 66,
    columnNumber: 3
  }
}));
const EqlTab = tabWithSuspense(/*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./eql')))), /*#__PURE__*/_react.default.createElement(_lazy_timeline_tab_renderer.TimelineTabFallback, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 70,
    columnNumber: 3
  }
}));
const NotesTab = tabWithSuspense(/*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./notes')))), /*#__PURE__*/_react.default.createElement(_lazy_timeline_tab_renderer.TimelineTabFallback, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 74,
    columnNumber: 3
  }
}));
const PinnedTab = tabWithSuspense(/*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./pinned')))), /*#__PURE__*/_react.default.createElement(_lazy_timeline_tab_renderer.TimelineTabFallback, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 78,
    columnNumber: 3
  }
}));
const EsqlTab = tabWithSuspense(/*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./esql')))), /*#__PURE__*/_react.default.createElement(_lazy_timeline_tab_renderer.TimelineTabFallback, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 82,
    columnNumber: 3
  }
}));
const ActiveTimelineTab = /*#__PURE__*/(0, _react.memo)(({
  activeTimelineTab,
  renderCellValue,
  rowRenderers,
  timelineId,
  timelineType,
  showTimeline
}) => {
  const {
    isEsqlAdvancedSettingEnabled
  } = (0, _use_esql_availability.useEsqlAvailability)();
  const timelineESQLSavedSearch = (0, _use_selector.useShallowEqualSelector)(state => (0, _selectors2.selectTimelineESQLSavedSearchId)(state, timelineId));
  const shouldShowESQLTab = (0, _react.useMemo)(() => isEsqlAdvancedSettingEnabled || timelineESQLSavedSearch != null, [isEsqlAdvancedSettingEnabled, timelineESQLSavedSearch]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_lazy_timeline_tab_renderer.LazyTimelineTabRenderer, {
    timelineId: timelineId,
    shouldShowTab: _timeline.TimelineTabs.query === activeTimelineTab,
    dataTestSubj: `timeline-tab-content-${_timeline.TimelineTabs.query}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(QueryTab, {
    renderCellValue: renderCellValue,
    rowRenderers: rowRenderers,
    timelineId: timelineId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 11
    }
  })), showTimeline && shouldShowESQLTab && activeTimelineTab === _timeline.TimelineTabs.esql && /*#__PURE__*/_react.default.createElement(_lazy_timeline_tab_renderer.LazyTimelineTabRenderer, {
    timelineId: timelineId,
    shouldShowTab: true,
    dataTestSubj: `timeline-tab-content-${_timeline.TimelineTabs.esql}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(EsqlTab, {
    timelineId: timelineId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_lazy_timeline_tab_renderer.LazyTimelineTabRenderer, {
    timelineId: timelineId,
    shouldShowTab: _timeline.TimelineTabs.pinned === activeTimelineTab,
    dataTestSubj: `timeline-tab-content-${_timeline.TimelineTabs.pinned}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(PinnedTab, {
    renderCellValue: renderCellValue,
    rowRenderers: rowRenderers,
    timelineId: timelineId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 11
    }
  })), timelineType === _timeline2.TimelineTypeEnum.default && /*#__PURE__*/_react.default.createElement(_lazy_timeline_tab_renderer.LazyTimelineTabRenderer, {
    timelineId: timelineId,
    shouldShowTab: _timeline.TimelineTabs.eql === activeTimelineTab,
    dataTestSubj: `timeline-tab-content-${_timeline.TimelineTabs.eql}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(EqlTab, {
    renderCellValue: renderCellValue,
    rowRenderers: rowRenderers,
    timelineId: timelineId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_lazy_timeline_tab_renderer.LazyTimelineTabRenderer, {
    timelineId: timelineId,
    shouldShowTab: activeTimelineTab === _timeline.TimelineTabs.notes,
    dataTestSubj: `timeline-tab-content-${_timeline.TimelineTabs.notes}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(NotesTab, {
    timelineId: timelineId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 11
    }
  })));
});
ActiveTimelineTab.displayName = 'ActiveTimelineTab';
const CountBadge = (0, _styledComponents.default)(_eui.EuiBadge)`
  margin-left: ${({
  theme
}) => theme.eui.euiSizeS};
`;
const StyledEuiTab = (0, _styledComponents.default)(_eui.EuiTab)`
  .euiTab__content {
    align-items: center;
    display: flex;
    flex-direction: row;
    white-space: pre;
  }

  :focus {
    text-decoration: none;

    > span > span {
      text-decoration: underline;
    }
  }
`;
const StyledEuiTabs = (0, _styledComponents.default)(_eui.EuiTabs)`
  padding-inline: ${props => props.theme.eui.euiSizeM};
`;
const TabsContentComponent = ({
  renderCellValue,
  rowRenderers,
  timelineId,
  timelineFullScreen,
  timelineType,
  timelineDescription
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const getActiveTab = (0, _react.useMemo)(() => (0, _selectors.getActiveTabSelector)(), []);
  const getShowTimeline = (0, _react.useMemo)(() => (0, _selectors.getShowTimelineSelector)(), []);
  const getNumberOfPinnedEvents = (0, _react.useMemo)(() => (0, _selectors.getPinnedEventSelector)(), []);
  const getAppNotes = (0, _react.useMemo)(() => (0, _selectors.getNotesSelector)(), []);
  const getTimelineNoteIds = (0, _react.useMemo)(() => (0, _selectors.getNoteIdsSelector)(), []);
  const getTimelinePinnedEventNotes = (0, _react.useMemo)(() => (0, _selectors.getEventIdToNoteIdsSelector)(), []);
  const {
    isEsqlAdvancedSettingEnabled
  } = (0, _use_esql_availability.useEsqlAvailability)();
  const timelineESQLSavedSearch = (0, _use_selector.useShallowEqualSelector)(state => (0, _selectors2.selectTimelineESQLSavedSearchId)(state, timelineId));
  const securitySolutionNotesDisabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('securitySolutionNotesDisabled');
  const activeTab = (0, _use_selector.useShallowEqualSelector)(state => getActiveTab(state, timelineId));
  const showTimeline = (0, _use_selector.useShallowEqualSelector)(state => getShowTimeline(state, timelineId));
  const shouldShowESQLTab = (0, _react.useMemo)(() => isEsqlAdvancedSettingEnabled || timelineESQLSavedSearch != null, [isEsqlAdvancedSettingEnabled, timelineESQLSavedSearch]);
  const numberOfPinnedEvents = (0, _use_selector.useShallowEqualSelector)(state => getNumberOfPinnedEvents(state, timelineId));
  const globalTimelineNoteIds = (0, _use_selector.useDeepEqualSelector)(state => getTimelineNoteIds(state, timelineId));
  const eventIdToNoteIds = (0, _use_selector.useDeepEqualSelector)(state => getTimelinePinnedEventNotes(state, timelineId));
  const appNotes = (0, _use_selector.useDeepEqualSelector)(state => getAppNotes(state));

  // old notes system (through timeline)
  const allTimelineNoteIds = (0, _react.useMemo)(() => {
    const eventNoteIds = Object.values(eventIdToNoteIds).reduce((acc, v) => [...acc, ...v], []);
    return [...globalTimelineNoteIds, ...eventNoteIds];
  }, [globalTimelineNoteIds, eventIdToNoteIds]);
  const numberOfNotesOldSystem = (0, _react.useMemo)(() => appNotes.filter(appNote => allTimelineNoteIds.includes(appNote.id)).length + ((0, _fp.isEmpty)(timelineDescription) ? 0 : 1), [appNotes, allTimelineNoteIds, timelineDescription]);
  const timeline = (0, _reactRedux.useSelector)(state => (0, _selectors2.selectTimelineById)(state, timelineId));
  const timelineSavedObjectId = (0, _react.useMemo)(() => {
    var _timeline$savedObject;
    return (_timeline$savedObject = timeline === null || timeline === void 0 ? void 0 : timeline.savedObjectId) !== null && _timeline$savedObject !== void 0 ? _timeline$savedObject : '';
  }, [timeline]);
  const isTimelineSaved = (0, _react.useMemo)(() => timelineSavedObjectId.length > 0, [timelineSavedObjectId]);
  const {
    notesPrivileges: {
      read: canSeeNotes
    },
    timelinePrivileges: {
      read: canSeePinnedTab
    }
  } = (0, _user_privileges.useUserPrivileges)();

  // new note system
  const fetchNotes = (0, _react.useCallback)(() => dispatch((0, _notes.fetchNotesBySavedObjectIds)({
    savedObjectIds: [timelineSavedObjectId]
  })), [dispatch, timelineSavedObjectId]);
  (0, _react.useEffect)(() => {
    if (isTimelineSaved) {
      fetchNotes();
    }
  }, [fetchNotes, isTimelineSaved]);
  const selectNotesBySavedObjectId = (0, _react.useMemo)(() => (0, _notes.makeSelectNotesBySavedObjectId)(), []);
  const notesNewSystem = (0, _reactRedux.useSelector)(state => selectNotesBySavedObjectId(state, timelineSavedObjectId));
  const numberOfNotesNewSystem = (0, _react.useMemo)(() => notesNewSystem.length + ((0, _fp.isEmpty)(timelineDescription) ? 0 : 1), [notesNewSystem, timelineDescription]);
  const numberOfNotes = (0, _react.useMemo)(() => securitySolutionNotesDisabled ? numberOfNotesOldSystem : numberOfNotesNewSystem, [numberOfNotesNewSystem, numberOfNotesOldSystem, securitySolutionNotesDisabled]);
  const setActiveTab = (0, _react.useCallback)(tab => {
    dispatch(_store.timelineActions.setActiveTabTimeline({
      id: timelineId,
      activeTab: tab
    }));
  }, [dispatch, timelineId]);
  const setQueryAsActiveTab = (0, _react.useCallback)(() => {
    setActiveTab(_timeline.TimelineTabs.query);
  }, [setActiveTab]);
  const setEqlAsActiveTab = (0, _react.useCallback)(() => {
    setActiveTab(_timeline.TimelineTabs.eql);
  }, [setActiveTab]);
  const setNotesAsActiveTab = (0, _react.useCallback)(() => {
    setActiveTab(_timeline.TimelineTabs.notes);
  }, [setActiveTab]);
  const setPinnedAsActiveTab = (0, _react.useCallback)(() => {
    setActiveTab(_timeline.TimelineTabs.pinned);
  }, [setActiveTab]);
  const setEsqlAsActiveTab = (0, _react.useCallback)(() => {
    dispatch((0, _actions.initializeTimelineSettings)({
      id: timelineId
    }));
    setActiveTab(_timeline.TimelineTabs.esql);
  }, [setActiveTab, dispatch, timelineId]);
  (0, _react.useEffect)(() => {
    // we redirect to the Query tab when we try to load Timeline urls with the Session or Analyzer tabs active
    // Session View and Analyzer graph are now only rendered in the flyout
    // @ts-ignore
    if (activeTab === 'graph' || activeTab === 'session') {
      setQueryAsActiveTab();
    }
  }, [activeTab, setQueryAsActiveTab]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !timelineFullScreen && /*#__PURE__*/_react.default.createElement(StyledEuiTabs, {
    className: "eui-scrollBar",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 343,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(StyledEuiTab, {
    "data-test-subj": `timelineTabs-${_timeline.TimelineTabs.query}`,
    onClick: setQueryAsActiveTab,
    isSelected: activeTab === _timeline.TimelineTabs.query,
    disabled: false,
    key: _timeline.TimelineTabs.query,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 344,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 351,
      columnNumber: 13
    }
  }, i18n.QUERY_TAB), showTimeline && /*#__PURE__*/_react.default.createElement(_use_timeline_events_count.TimelineEventsCountBadge, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 352,
      columnNumber: 30
    }
  })), shouldShowESQLTab && /*#__PURE__*/_react.default.createElement(StyledEuiTab, {
    "data-test-subj": `timelineTabs-${_timeline.TimelineTabs.esql}`,
    onClick: setEsqlAsActiveTab,
    isSelected: activeTab === _timeline.TimelineTabs.esql,
    disabled: false,
    key: _timeline.TimelineTabs.esql,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 355,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 362,
      columnNumber: 15
    }
  }, i18n.DISCOVER_ESQL_IN_TIMELINE_TAB)), timelineType === _timeline2.TimelineTypeEnum.default && /*#__PURE__*/_react.default.createElement(StyledEuiTab, {
    "data-test-subj": `timelineTabs-${_timeline.TimelineTabs.eql}`,
    onClick: setEqlAsActiveTab,
    isSelected: activeTab === _timeline.TimelineTabs.eql,
    disabled: false,
    key: _timeline.TimelineTabs.eql,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 366,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 373,
      columnNumber: 15
    }
  }, i18n.EQL_TAB), showTimeline && /*#__PURE__*/_react.default.createElement(_use_timeline_events_count.EqlEventsCountBadge, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 374,
      columnNumber: 32
    }
  })), /*#__PURE__*/_react.default.createElement(StyledEuiTab, {
    "data-test-subj": `timelineTabs-${_timeline.TimelineTabs.notes}`,
    onClick: setNotesAsActiveTab,
    isSelected: activeTab === _timeline.TimelineTabs.notes,
    disabled: !canSeeNotes || timelineType === _timeline2.TimelineTypeEnum.template,
    key: _timeline.TimelineTabs.notes,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 377,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 384,
      columnNumber: 13
    }
  }, i18n.NOTES_TAB), showTimeline && numberOfNotes > 0 && timelineType === _timeline2.TimelineTypeEnum.default && /*#__PURE__*/_react.default.createElement(CountBadge, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 386,
      columnNumber: 15
    }
  }, numberOfNotes)), /*#__PURE__*/_react.default.createElement(StyledEuiTab, {
    "data-test-subj": `timelineTabs-${_timeline.TimelineTabs.pinned}`,
    onClick: setPinnedAsActiveTab,
    disabled: !canSeePinnedTab || timelineType === _timeline2.TimelineTypeEnum.template,
    isSelected: activeTab === _timeline.TimelineTabs.pinned,
    key: _timeline.TimelineTabs.pinned,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 389,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 396,
      columnNumber: 13
    }
  }, i18n.PINNED_TAB), showTimeline && numberOfPinnedEvents > 0 && timelineType === _timeline2.TimelineTypeEnum.default && /*#__PURE__*/_react.default.createElement(CountBadge, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 400,
      columnNumber: 17
    }
  }, numberOfPinnedEvents))), /*#__PURE__*/_react.default.createElement(ActiveTimelineTab, {
    activeTimelineTab: activeTab,
    renderCellValue: renderCellValue,
    rowRenderers: rowRenderers,
    timelineId: timelineId,
    timelineType: timelineType,
    timelineDescription: timelineDescription,
    showTimeline: showTimeline,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 406,
      columnNumber: 7
    }
  }));
};
const TabsContent = exports.TabsContent = /*#__PURE__*/(0, _react.memo)(TabsContentComponent);