"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSearchBarCustomizations = void 0;
var _use_get_stateful_query_bar = require("../use_get_stateful_query_bar");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSearchBarCustomizations = () => {
  const {
    CustomStatefulTopNavKqlQueryBar
  } = (0, _use_get_stateful_query_bar.useGetStatefulQueryBar)();
  const setSearchBarCustomizations = ({
    customizations
  }) => {
    customizations.set({
      id: 'search_bar',
      CustomSearchBar: CustomStatefulTopNavKqlQueryBar,
      hideDataViewPicker: true
    });
  };
  return setSearchBarCustomizations;
};
exports.useSearchBarCustomizations = useSearchBarCustomizations;