"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEqlOptions = void 0;
var _reselect = require("reselect");
var _selectors = require("../../../../store/selectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getEqlOptions = () => (0, _reselect.createSelector)(_selectors.selectTimeline, timeline => {
  var _timeline$eqlOptions;
  return (_timeline$eqlOptions = timeline === null || timeline === void 0 ? void 0 : timeline.eqlOptions) !== null && _timeline$eqlOptions !== void 0 ? _timeline$eqlOptions : {
    eventCategoryField: 'event.category',
    timestampField: [{
      label: '@timestamp'
    }],
    size: 100,
    query: ''
  };
});
exports.getEqlOptions = getEqlOptions;