"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotificationDot = exports.NotesButton = exports.NOTES_BUTTON_CLASS_NAME = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _timeline = require("../../../../../common/api/timeline");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/timeline/properties/helpers.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const NotificationDot = exports.NotificationDot = _styledComponents.default.span`
  position: absolute;
  display: block;
  width: 6px;
  height: 6px;
  border-radius: 50%;
  background-color: ${({
  theme
}) => theme.eui.euiColorDanger};
  top: 17%;
  left: 52%;
`;
const NOTES_BUTTON_CLASS_NAME = exports.NOTES_BUTTON_CLASS_NAME = 'notes-button';
const NotesButtonContainer = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  position: relative;
`;
const SmallNotesButton = /*#__PURE__*/_react.default.memo(({
  ariaLabel = i18n.NOTES,
  isDisabled,
  toggleShowNotes,
  timelineType,
  eventId,
  notesCount
}) => {
  const isTemplate = timelineType === _timeline.TimelineTypeEnum.template;
  const onClick = (0, _react.useCallback)(() => {
    if (eventId != null) {
      toggleShowNotes === null || toggleShowNotes === void 0 ? void 0 : toggleShowNotes(eventId);
    } else {
      toggleShowNotes === null || toggleShowNotes === void 0 ? void 0 : toggleShowNotes();
    }
  }, [toggleShowNotes, eventId]);
  return /*#__PURE__*/_react.default.createElement(NotesButtonContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 9
    }
  }, notesCount > 0 ? /*#__PURE__*/_react.default.createElement(NotificationDot, {
    className: "timeline-notes-notification-dot",
    "data-test-subj": "timeline-notes-notification-dot",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 13
    }
  }) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": ariaLabel,
    className: NOTES_BUTTON_CLASS_NAME,
    "data-test-subj": "timeline-notes-button-small",
    disabled: isDisabled,
    iconType: "editorComment",
    onClick: onClick,
    size: "s",
    isDisabled: isTemplate,
    color: "text",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 11
    }
  })));
});
SmallNotesButton.displayName = 'SmallNotesButton';
const NotesButton = exports.NotesButton = /*#__PURE__*/_react.default.memo(({
  ariaLabel,
  isDisabled,
  timelineType,
  toggleShowNotes,
  toolTip,
  eventId,
  notesCount
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  content: toolTip,
  "data-test-subj": "timeline-notes-tool-tip",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 98,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(SmallNotesButton, {
  ariaLabel: ariaLabel,
  isDisabled: isDisabled,
  toggleShowNotes: toggleShowNotes,
  timelineType: timelineType,
  eventId: eventId,
  notesCount: notesCount !== null && notesCount !== void 0 ? notesCount : 0,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 99,
    columnNumber: 7
  }
})));
NotesButton.displayName = 'NotesButton';