"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.systemRowRenderers = exports.createSocketRowRenderer = exports.createSecurityEventRowRenderer = exports.createGenericSystemRowRenderer = exports.createGenericFileRowRenderer = exports.createFimRowRenderer = exports.createEndpointRegistryRowRenderer = exports.createEndpointLibraryRowRenderer = exports.createEndpointAlertsRowRenderer = exports.createEndgameProcessRowRenderer = exports.createDnsRowRenderer = void 0;
var _fp = require("lodash/fp");
var _react = _interopRequireDefault(require("react"));
var _timeline = require("../../../../../../../common/api/timeline");
var _dns_request_event_details = require("../dns/dns_request_event_details");
var _endgame_security_event_details = require("../endgame/endgame_security_event_details");
var _helpers = require("../helpers");
var _registry_event_details = require("../registry/registry_event_details");
var _row_renderer = require("../row_renderer");
var _generic_details = require("./generic_details");
var _generic_file_details = require("./generic_file_details");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/timeline/body/renderers/system/generic_row_renderer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const createGenericSystemRowRenderer = ({
  actionName,
  text
}) => ({
  id: _timeline.RowRendererIdEnum.system,
  isInstance: ecs => {
    const module = (0, _fp.get)('event.module[0]', ecs);
    const action = (0, _fp.get)('event.action[0]', ecs);
    return module != null && module.toLowerCase() === 'system' && action != null && action.toLowerCase() === actionName;
  },
  renderRow: ({
    data,
    scopeId
  }) => /*#__PURE__*/_react.default.createElement(_row_renderer.RowRendererContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_generic_details.SystemGenericDetails, {
    contextId: `${actionName}-${scopeId}`,
    data: data,
    text: text,
    timelineId: scopeId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 7
    }
  }))
});
exports.createGenericSystemRowRenderer = createGenericSystemRowRenderer;
const createEndgameProcessRowRenderer = ({
  actionName,
  text
}) => ({
  id: _timeline.RowRendererIdEnum.system_file,
  isInstance: ecs => {
    const action = (0, _fp.get)('event.action[0]', ecs);
    const category = (0, _fp.get)('event.category[0]', ecs);
    const dataset = (0, _fp.get)('event.dataset[0]', ecs);
    return ((category === null || category === void 0 ? void 0 : category.toLowerCase()) === 'process' || (dataset === null || dataset === void 0 ? void 0 : dataset.toLowerCase()) === 'endpoint.events.process') && (action === null || action === void 0 ? void 0 : action.toLowerCase()) === actionName;
  },
  renderRow: ({
    data,
    scopeId
  }) => /*#__PURE__*/_react.default.createElement(_row_renderer.RowRendererContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_generic_file_details.SystemGenericFileDetails, {
    data: data,
    contextId: `endgame-process-${actionName}-${scopeId}`,
    showMessage: false,
    text: text,
    scopeId: scopeId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 7
    }
  }))
});
exports.createEndgameProcessRowRenderer = createEndgameProcessRowRenderer;
const createFimRowRenderer = ({
  actionName,
  text
}) => ({
  id: _timeline.RowRendererIdEnum.system_fim,
  isInstance: ecs => {
    const action = (0, _fp.get)('event.action[0]', ecs);
    const category = (0, _fp.get)('event.category[0]', ecs);
    const dataset = (0, _fp.get)('event.dataset[0]', ecs);
    return (0, _helpers.isFileEvent)({
      eventCategory: category,
      eventDataset: dataset
    }) && (action === null || action === void 0 ? void 0 : action.toLowerCase()) === actionName;
  },
  renderRow: ({
    data,
    scopeId
  }) => /*#__PURE__*/_react.default.createElement(_row_renderer.RowRendererContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_generic_file_details.SystemGenericFileDetails, {
    data: data,
    contextId: `fim-${actionName}-${scopeId}`,
    showMessage: false,
    text: text,
    scopeId: scopeId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 7
    }
  }))
});
exports.createFimRowRenderer = createFimRowRenderer;
const createEndpointAlertsRowRenderer = ({
  eventAction,
  eventCategory,
  eventType,
  skipRedundantFileDetails = false,
  skipRedundantProcessDetails = false,
  text
}) => ({
  id: _timeline.RowRendererIdEnum.alerts,
  isInstance: ecs => {
    var _action$includes, _category$includes, _type$includes;
    const action = (0, _fp.get)('event.action', ecs);
    const category = (0, _fp.get)('event.category', ecs);
    const dataset = (0, _fp.get)('event.dataset[0]', ecs);
    const type = (0, _fp.get)('event.type', ecs);
    const eventActionMatches = (_action$includes = action === null || action === void 0 ? void 0 : action.includes(eventAction)) !== null && _action$includes !== void 0 ? _action$includes : false;
    const eventCategoryMatches = (_category$includes = category === null || category === void 0 ? void 0 : category.includes(eventCategory)) !== null && _category$includes !== void 0 ? _category$includes : false;
    const eventTypeMatches = (_type$includes = type === null || type === void 0 ? void 0 : type.includes(eventType)) !== null && _type$includes !== void 0 ? _type$includes : false;
    return (dataset === null || dataset === void 0 ? void 0 : dataset.toLowerCase()) === 'endpoint.alerts' && eventTypeMatches && eventCategoryMatches && eventActionMatches;
  },
  renderRow: ({
    data,
    scopeId
  }) => /*#__PURE__*/_react.default.createElement(_row_renderer.RowRendererContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_generic_file_details.SystemGenericFileDetails, {
    contextId: `endpoint-alerts-row-renderer-${eventAction}-${eventCategory}-${eventType}-${scopeId}`,
    data: data,
    showMessage: false,
    skipRedundantFileDetails: skipRedundantFileDetails,
    skipRedundantProcessDetails: skipRedundantProcessDetails,
    text: text,
    scopeId: scopeId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 7
    }
  }))
});
exports.createEndpointAlertsRowRenderer = createEndpointAlertsRowRenderer;
const createEndpointLibraryRowRenderer = ({
  actionName,
  text
}) => ({
  id: _timeline.RowRendererIdEnum.library,
  isInstance: ecs => {
    const action = (0, _fp.get)('event.action[0]', ecs);
    const dataset = (0, _fp.get)('event.dataset[0]', ecs);
    return (dataset === null || dataset === void 0 ? void 0 : dataset.toLowerCase()) === 'endpoint.events.library' && (action === null || action === void 0 ? void 0 : action.toLowerCase()) === actionName;
  },
  renderRow: ({
    data,
    scopeId
  }) => /*#__PURE__*/_react.default.createElement(_row_renderer.RowRendererContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_generic_file_details.SystemGenericFileDetails, {
    contextId: `library-row-renderer-${actionName}-${scopeId}`,
    data: data,
    showMessage: false,
    text: text,
    scopeId: scopeId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 7
    }
  }))
});
exports.createEndpointLibraryRowRenderer = createEndpointLibraryRowRenderer;
const createGenericFileRowRenderer = ({
  actionName,
  text
}) => ({
  id: _timeline.RowRendererIdEnum.system_file,
  isInstance: ecs => {
    const module = (0, _fp.get)('event.module[0]', ecs);
    const action = (0, _fp.get)('event.action[0]', ecs);
    return module != null && module.toLowerCase() === 'system' && action != null && action.toLowerCase() === actionName;
  },
  renderRow: ({
    data,
    scopeId
  }) => /*#__PURE__*/_react.default.createElement(_row_renderer.RowRendererContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_generic_file_details.SystemGenericFileDetails, {
    contextId: `${actionName}-${scopeId}`,
    data: data,
    text: text,
    scopeId: scopeId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 7
    }
  }))
});
exports.createGenericFileRowRenderer = createGenericFileRowRenderer;
const createSocketRowRenderer = ({
  actionName,
  text
}) => ({
  id: _timeline.RowRendererIdEnum.system_socket,
  isInstance: ecs => {
    const action = (0, _fp.get)('event.action[0]', ecs);
    return action != null && action.toLowerCase() === actionName;
  },
  renderRow: ({
    data,
    scopeId
  }) => /*#__PURE__*/_react.default.createElement(_row_renderer.RowRendererContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 236,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_generic_file_details.SystemGenericFileDetails, {
    contextId: `socket-${actionName}-${scopeId}`,
    data: data,
    text: text,
    scopeId: scopeId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 237,
      columnNumber: 7
    }
  }))
});
exports.createSocketRowRenderer = createSocketRowRenderer;
const createSecurityEventRowRenderer = ({
  actionName
}) => ({
  id: _timeline.RowRendererIdEnum.system_security_event,
  isInstance: ecs => {
    const category = (0, _fp.get)('event.category[0]', ecs);
    const action = (0, _fp.get)('event.action[0]', ecs);
    const dataset = (0, _fp.get)('event.dataset[0]', ecs);
    return ((category === null || category === void 0 ? void 0 : category.toLowerCase()) === 'authentication' || (dataset === null || dataset === void 0 ? void 0 : dataset.toLowerCase()) === 'endpoint.events.security') && (action === null || action === void 0 ? void 0 : action.toLowerCase()) === actionName;
  },
  renderRow: ({
    data,
    scopeId
  }) => /*#__PURE__*/_react.default.createElement(_row_renderer.RowRendererContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 264,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_endgame_security_event_details.EndgameSecurityEventDetails, {
    contextId: `authentication-${actionName}-${scopeId}`,
    data: data,
    timelineId: scopeId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 265,
      columnNumber: 7
    }
  }))
});
exports.createSecurityEventRowRenderer = createSecurityEventRowRenderer;
const createDnsRowRenderer = () => ({
  id: _timeline.RowRendererIdEnum.system_dns,
  isInstance: ecs => {
    const dnsQuestionType = (0, _fp.get)('dns.question.type[0]', ecs);
    const dnsQuestionName = (0, _fp.get)('dns.question.name[0]', ecs);
    return !(0, _helpers.isNillEmptyOrNotFinite)(dnsQuestionType) && !(0, _helpers.isNillEmptyOrNotFinite)(dnsQuestionName);
  },
  renderRow: ({
    data,
    scopeId
  }) => /*#__PURE__*/_react.default.createElement(_row_renderer.RowRendererContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 282,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_dns_request_event_details.DnsRequestEventDetails, {
    contextId: `dns-request-${scopeId}`,
    data: data,
    timelineId: scopeId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 283,
      columnNumber: 7
    }
  }))
});
exports.createDnsRowRenderer = createDnsRowRenderer;
const createEndpointRegistryRowRenderer = ({
  actionName,
  text
}) => ({
  id: _timeline.RowRendererIdEnum.registry,
  isInstance: ecs => {
    const action = (0, _fp.get)('event.action[0]', ecs);
    const dataset = (0, _fp.get)('event.dataset[0]', ecs);
    return (dataset === null || dataset === void 0 ? void 0 : dataset.toLowerCase()) === 'endpoint.events.registry' && (action === null || action === void 0 ? void 0 : action.toLowerCase()) === actionName;
  },
  renderRow: ({
    data,
    scopeId
  }) => /*#__PURE__*/_react.default.createElement(_row_renderer.RowRendererContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 309,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_registry_event_details.RegistryEventDetails, {
    contextId: `registry-event-${scopeId}`,
    data: data,
    text: text,
    scopeId: scopeId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 310,
      columnNumber: 7
    }
  }))
});
exports.createEndpointRegistryRowRenderer = createEndpointRegistryRowRenderer;
const systemLoginRowRenderer = createGenericSystemRowRenderer({
  actionName: 'user_login',
  text: i18n.ATTEMPTED_LOGIN
});
const systemProcessStartedRowRenderer = createGenericFileRowRenderer({
  actionName: 'process_started',
  text: i18n.PROCESS_STARTED
});
const endgameProcessStartedRowRenderer = createEndgameProcessRowRenderer({
  actionName: 'creation_event',
  text: i18n.PROCESS_STARTED
});
const endpointProcessStartRowRenderer = createEndgameProcessRowRenderer({
  actionName: 'start',
  text: i18n.PROCESS_STARTED
});
const endpointRegistryModificationRowRenderer = createEndpointRegistryRowRenderer({
  actionName: 'modification',
  text: i18n.MODIFIED_REGISTRY_KEY
});
const systemProcessStoppedRowRenderer = createGenericFileRowRenderer({
  actionName: 'process_stopped',
  text: i18n.PROCESS_STOPPED
});
const endgameProcessTerminationRowRenderer = createEndgameProcessRowRenderer({
  actionName: 'termination_event',
  text: i18n.TERMINATED_PROCESS
});
const endpointProcessEndRowRenderer = createEndgameProcessRowRenderer({
  actionName: 'end',
  text: i18n.TERMINATED_PROCESS
});
const endgameFileCreateEventRowRenderer = createFimRowRenderer({
  actionName: 'file_create_event',
  text: i18n.CREATED_FILE
});
const endpointFileCreationEventRowRenderer = createFimRowRenderer({
  actionName: 'creation',
  text: i18n.CREATED_FILE
});
const fimFileCreateEventRowRenderer = createFimRowRenderer({
  actionName: 'created',
  text: i18n.CREATED_FILE
});
const endgameFileDeleteEventRowRenderer = createFimRowRenderer({
  actionName: 'file_delete_event',
  text: i18n.DELETED_FILE
});
const endpointFileDeletionEventRowRenderer = createFimRowRenderer({
  actionName: 'deletion',
  text: i18n.DELETED_FILE
});
const endpointModificationEventRowRenderer = createFimRowRenderer({
  actionName: 'modification',
  text: i18n.MODIFIED_FILE
});
const endpointFileOverwriteEventRowRenderer = createFimRowRenderer({
  actionName: 'overwrite',
  text: i18n.OVERWROTE_FILE
});
const endpointFileRenamedEventRowRenderer = createFimRowRenderer({
  actionName: 'rename',
  text: i18n.RENAMED_FILE
});
const fimFileDeletedEventRowRenderer = createFimRowRenderer({
  actionName: 'deleted',
  text: i18n.DELETED_FILE
});
const systemExistingRowRenderer = createGenericFileRowRenderer({
  actionName: 'existing_process',
  text: i18n.EXISTING_PROCESS
});
const endpointAlertCriteria = [{
  eventAction: 'creation',
  eventCategory: 'file',
  eventType: 'denied',
  skipRedundantProcessDetails: true,
  text: i18n.WAS_PREVENTED_FROM_CREATING_A_MALICIOUS_FILE
}, {
  eventAction: 'creation',
  eventCategory: 'file',
  eventType: 'allowed',
  skipRedundantProcessDetails: true,
  text: i18n.WAS_DETECTED_CREATING_A_MALICIOUS_FILE
}, {
  eventAction: 'files-encrypted',
  eventCategory: 'file',
  eventType: 'denied',
  skipRedundantFileDetails: true,
  text: i18n.RANSOMWARE_WAS_PREVENTED_FROM_ENCRYPTING_FILES
}, {
  eventAction: 'files-encrypted',
  eventCategory: 'file',
  eventType: 'allowed',
  skipRedundantFileDetails: true,
  text: i18n.RANSOMWARE_WAS_DETECTED_ENCRYPTING_FILES
}, {
  eventAction: 'modification',
  eventCategory: 'file',
  eventType: 'denied',
  skipRedundantProcessDetails: true,
  text: i18n.WAS_PREVENTED_FROM_MODIFYING_A_MALICIOUS_FILE
}, {
  eventAction: 'modification',
  eventCategory: 'file',
  eventType: 'allowed',
  skipRedundantProcessDetails: true,
  text: i18n.WAS_DETECTED_MODIFYING_A_MALICIOUS_FILE
}, {
  eventAction: 'rename',
  eventCategory: 'file',
  eventType: 'denied',
  skipRedundantProcessDetails: true,
  text: i18n.WAS_PREVENTED_FROM_RENAMING_A_MALICIOUS_FILE
}, {
  eventAction: 'rename',
  eventCategory: 'file',
  eventType: 'allowed',
  skipRedundantProcessDetails: true,
  text: i18n.WAS_DETECTED_RENAMING_A_MALICIOUS_FILE
}, {
  eventAction: 'execution',
  eventCategory: 'process',
  eventType: 'denied',
  skipRedundantFileDetails: true,
  text: i18n.WAS_PREVENTED_FROM_EXECUTING_A_MALICIOUS_PROCESS
}, {
  eventAction: 'execution',
  eventCategory: 'process',
  eventType: 'allowed',
  skipRedundantFileDetails: true,
  text: i18n.WAS_DETECTED_EXECUTING_A_MALICIOUS_PROCESS
}];
const endpointAlertsRowRenderers = endpointAlertCriteria.map(criteria => createEndpointAlertsRowRenderer(criteria));
const endpointLibraryLoadRowRenderer = createEndpointLibraryRowRenderer({
  actionName: 'load',
  text: i18n.LOADED_LIBRARY
});
const systemSocketOpenedRowRenderer = createSocketRowRenderer({
  actionName: 'socket_opened',
  text: i18n.SOCKET_OPENED
});
const systemSocketClosedRowRenderer = createSocketRowRenderer({
  actionName: 'socket_closed',
  text: i18n.SOCKET_CLOSED
});
const endgameIpv4ConnectionAcceptEventRowRenderer = createSocketRowRenderer({
  actionName: 'ipv4_connection_accept_event',
  text: i18n.ACCEPTED_A_CONNECTION_VIA
});
const endpointConnectionAcceptedEventRowRenderer = createSocketRowRenderer({
  actionName: 'connection_accepted',
  text: i18n.ACCEPTED_A_CONNECTION_VIA
});
const endpointHttpRequestEventRowRenderer = createSocketRowRenderer({
  actionName: 'http_request',
  text: i18n.MADE_A_HTTP_REQUEST_VIA
});
const endpointProcessExecRowRenderer = createEndgameProcessRowRenderer({
  actionName: 'exec',
  text: i18n.EXECUTED_PROCESS
});
const endpointProcessForkRowRenderer = createEndgameProcessRowRenderer({
  actionName: 'fork',
  text: i18n.FORKED_PROCESS
});
const endgameIpv6ConnectionAcceptEventRowRenderer = createSocketRowRenderer({
  actionName: 'ipv6_connection_accept_event',
  text: i18n.ACCEPTED_A_CONNECTION_VIA
});
const endgameIpv4DisconnectReceivedEventRowRenderer = createSocketRowRenderer({
  actionName: 'ipv4_disconnect_received_event',
  text: i18n.DISCONNECTED_VIA
});
const endpointDisconnectReceivedEventRowRenderer = createSocketRowRenderer({
  actionName: 'disconnect_received',
  text: i18n.DISCONNECTED_VIA
});
const endgameIpv6DisconnectReceivedEventRowRenderer = createSocketRowRenderer({
  actionName: 'ipv6_disconnect_received_event',
  text: i18n.DISCONNECTED_VIA
});
const endgameAdminLogonRowRenderer = createSecurityEventRowRenderer({
  actionName: 'admin_logon'
});
const endgameExplicitUserLogonRowRenderer = createSecurityEventRowRenderer({
  actionName: 'explicit_user_logon'
});
const endgameUserLogoffRowRenderer = createSecurityEventRowRenderer({
  actionName: 'user_logoff'
});
const endgameUserLogonRowRenderer = createSecurityEventRowRenderer({
  actionName: 'user_logon'
});
const endpointUserLogOnRowRenderer = createSecurityEventRowRenderer({
  actionName: 'log_on'
});
const dnsRowRenderer = createDnsRowRenderer();
const systemExistingUserRowRenderer = createGenericSystemRowRenderer({
  actionName: 'existing_user',
  text: i18n.EXISTING_USER
});
const systemExistingSocketRowRenderer = createGenericFileRowRenderer({
  actionName: 'existing_socket',
  text: i18n.EXISTING_SOCKET
});
const systemExistingPackageRowRenderer = createGenericSystemRowRenderer({
  actionName: 'existing_package',
  text: i18n.EXISTING_PACKAGE
});
const systemInvalidRowRenderer = createGenericFileRowRenderer({
  actionName: 'invalid',
  text: i18n.INVALID
});
const systemUserChangedRowRenderer = createGenericSystemRowRenderer({
  actionName: 'user_changed',
  text: i18n.USER_CHANGED
});
const systemHostChangedRowRenderer = createGenericSystemRowRenderer({
  actionName: 'host',
  text: i18n.HOST_CHANGED
});
const systemUserAddedRowRenderer = createGenericSystemRowRenderer({
  actionName: 'user_added',
  text: i18n.USER_ADDED
});
const systemLogoutRowRenderer = createGenericSystemRowRenderer({
  actionName: 'user_logout',
  text: i18n.LOGGED_OUT
});
const endpointUserLogOffRowRenderer = createSecurityEventRowRenderer({
  actionName: 'log_off'
});
const systemProcessErrorRowRenderer = createGenericFileRowRenderer({
  actionName: 'process_error',
  text: i18n.PROCESS_ERROR
});

// TODO: Remove this once this has been replaced everywhere with "error" below
const systemErrorRowRendererDeprecated = createGenericSystemRowRenderer({
  actionName: 'error:',
  text: i18n.ERROR
});
const systemErrorRowRenderer = createGenericSystemRowRenderer({
  actionName: 'error',
  text: i18n.ERROR
});
const systemPackageInstalledRowRenderer = createGenericSystemRowRenderer({
  actionName: 'package_installed',
  text: i18n.PACKAGE_INSTALLED
});
const systemBootRowRenderer = createGenericSystemRowRenderer({
  actionName: 'boot',
  text: i18n.BOOT
});
const systemAcceptedRowRenderer = createGenericSystemRowRenderer({
  actionName: 'accepted',
  text: i18n.ACCEPTED
});
const systemPackageUpdatedRowRenderer = createGenericSystemRowRenderer({
  actionName: 'package_updated',
  text: i18n.PACKAGE_UPDATED
});
const systemPackageRemovedRowRenderer = createGenericSystemRowRenderer({
  actionName: 'package_removed',
  text: i18n.PACKAGE_REMOVED
});
const systemUserRemovedRowRenderer = createGenericSystemRowRenderer({
  actionName: 'user_removed',
  text: i18n.USER_REMOVED
});
const systemRowRenderers = exports.systemRowRenderers = [dnsRowRenderer, endgameAdminLogonRowRenderer, endgameExplicitUserLogonRowRenderer, endgameFileCreateEventRowRenderer, endpointFileCreationEventRowRenderer, endgameFileDeleteEventRowRenderer, endpointFileDeletionEventRowRenderer, endpointFileOverwriteEventRowRenderer, endpointFileRenamedEventRowRenderer, ...endpointAlertsRowRenderers, endpointLibraryLoadRowRenderer, endpointModificationEventRowRenderer, endpointRegistryModificationRowRenderer, endgameIpv4ConnectionAcceptEventRowRenderer, endpointConnectionAcceptedEventRowRenderer, endpointHttpRequestEventRowRenderer, endpointProcessExecRowRenderer, endpointProcessForkRowRenderer, endgameIpv6ConnectionAcceptEventRowRenderer, endgameIpv4DisconnectReceivedEventRowRenderer, endpointDisconnectReceivedEventRowRenderer, endgameIpv6DisconnectReceivedEventRowRenderer, endgameProcessStartedRowRenderer, endpointProcessStartRowRenderer, endgameProcessTerminationRowRenderer, endpointProcessEndRowRenderer, endgameUserLogoffRowRenderer, endgameUserLogonRowRenderer, endpointUserLogOnRowRenderer, fimFileCreateEventRowRenderer, fimFileDeletedEventRowRenderer, systemAcceptedRowRenderer, systemBootRowRenderer, systemErrorRowRenderer, systemErrorRowRendererDeprecated, systemExistingPackageRowRenderer, systemExistingRowRenderer, systemExistingSocketRowRenderer, systemExistingUserRowRenderer, systemHostChangedRowRenderer, systemInvalidRowRenderer, systemLoginRowRenderer, systemLogoutRowRenderer, endpointUserLogOffRowRenderer, systemPackageInstalledRowRenderer, systemPackageUpdatedRowRenderer, systemPackageRemovedRowRenderer, systemProcessErrorRowRenderer, systemProcessStartedRowRenderer, systemProcessStoppedRowRenderer, systemSocketClosedRowRenderer, systemSocketOpenedRowRenderer, systemUserAddedRowRenderer, systemUserChangedRowRenderer, systemUserRemovedRowRenderer];