"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThreatMatchRowView = exports.ThreatMatchRow = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _fp = require("lodash/fp");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("../../../../../../../common/cti/constants");
var _match_details = require("./match_details");
var _indicator_details = require("./indicator_details");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/timeline/body/renderers/cti/threat_match_row.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ThreatMatchRow = ({
  contextId,
  data,
  eventId,
  scopeId
}) => {
  const props = {
    contextId,
    eventId,
    indicatorReference: (0, _fp.getOr)([], _constants.REFERENCE, data)[0],
    feedName: (0, _fp.getOr)([], _constants.FEED_NAME, data)[0],
    indicatorType: (0, _fp.getOr)([], _constants.MATCHED_TYPE, data)[0],
    sourceField: (0, _fp.get)(_constants.MATCHED_FIELD, data)[0],
    sourceValue: (0, _fp.get)(_constants.MATCHED_ATOMIC, data)[0],
    scopeId
  };
  return /*#__PURE__*/_react.default.createElement(ThreatMatchRowView, (0, _extends2.default)({}, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 10
    }
  }));
};
exports.ThreatMatchRow = ThreatMatchRow;
const ThreatMatchRowView = ({
  contextId,
  eventId,
  feedName,
  indicatorReference,
  indicatorType,
  sourceField,
  sourceValue,
  scopeId
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    "data-test-subj": "threat-match-row",
    gutterSize: "s",
    justifyContent: "center",
    wrap: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_match_details.MatchDetails, {
    scopeId: scopeId,
    contextId: contextId,
    eventId: eventId,
    sourceField: sourceField,
    sourceValue: sourceValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_indicator_details.IndicatorDetails, {
    scopeId: scopeId,
    contextId: contextId,
    eventId: eventId,
    feedName: feedName,
    indicatorReference: indicatorReference,
    indicatorType: indicatorType,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 9
    }
  })));
};
exports.ThreatMatchRowView = ThreatMatchRowView;