"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.nilOrUnSet = exports.PrimarySecondaryUserInfo = exports.PrimarySecondary = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _draggables = require("../../../../../../common/components/draggables");
var i18n = _interopRequireWildcard(require("./translations"));
var _helpers = require("../helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/timeline/body/renderers/auditd/primary_secondary_user_info.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const nilOrUnSet = value => value == null || value.toLowerCase() === 'unset';
exports.nilOrUnSet = nilOrUnSet;
const PrimarySecondary = exports.PrimarySecondary = /*#__PURE__*/_react.default.memo(({
  contextId,
  eventId,
  primary,
  secondary,
  scopeId
}) => {
  if (nilOrUnSet(primary) && nilOrUnSet(secondary)) {
    return null;
  } else if (!nilOrUnSet(primary) && nilOrUnSet(secondary)) {
    return /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
      scopeId: scopeId,
      contextId: contextId,
      eventId: eventId,
      field: "auditd.summary.actor.primary",
      value: primary,
      iconType: "user",
      isAggregatable: true,
      fieldType: "keyword",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 33,
        columnNumber: 9
      }
    });
  } else if (nilOrUnSet(primary) && !nilOrUnSet(secondary)) {
    return /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
      scopeId: scopeId,
      contextId: contextId,
      eventId: eventId,
      field: "auditd.summary.actor.secondary",
      value: secondary,
      iconType: "user",
      isAggregatable: true,
      fieldType: "keyword",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 9
      }
    });
  } else if (primary === secondary) {
    return /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
      scopeId: scopeId,
      contextId: contextId,
      eventId: eventId,
      field: "auditd.summary.actor.secondary",
      value: secondary,
      iconType: "user",
      isAggregatable: true,
      fieldType: "keyword",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 9
      }
    });
  } else {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "none",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
      grow: false,
      component: "span",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
      scopeId: scopeId,
      contextId: contextId,
      eventId: eventId,
      field: "auditd.summary.actor.primary",
      value: primary,
      iconType: "user",
      isAggregatable: true,
      fieldType: "keyword",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
      grow: false,
      component: "span",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 11
      }
    }, i18n.AS), /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
      grow: false,
      component: "span",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
      scopeId: scopeId,
      contextId: contextId,
      eventId: eventId,
      field: "auditd.summary.actor.secondary",
      value: secondary,
      iconType: "user",
      isAggregatable: true,
      fieldType: "keyword",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 13
      }
    })));
  }
});
PrimarySecondary.displayName = 'PrimarySecondary';
const PrimarySecondaryUserInfo = exports.PrimarySecondaryUserInfo = /*#__PURE__*/_react.default.memo(({
  contextId,
  eventId,
  userName,
  primary,
  secondary,
  scopeId
}) => {
  if (nilOrUnSet(userName) && nilOrUnSet(primary) && nilOrUnSet(secondary)) {
    return null;
  } else if (!nilOrUnSet(userName) && !nilOrUnSet(primary) && !nilOrUnSet(secondary) && userName === primary && userName === secondary) {
    return /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
      scopeId: scopeId,
      contextId: contextId,
      eventId: eventId,
      field: "user.name",
      value: userName,
      iconType: "user",
      isAggregatable: true,
      fieldType: "keyword",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 129,
        columnNumber: 9
      }
    });
  } else if (!nilOrUnSet(userName) && nilOrUnSet(primary) && nilOrUnSet(secondary)) {
    return /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
      scopeId: scopeId,
      contextId: contextId,
      eventId: eventId,
      field: "user.name",
      value: userName,
      iconType: "user",
      isAggregatable: true,
      fieldType: "keyword",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 142,
        columnNumber: 9
      }
    });
  } else {
    return /*#__PURE__*/_react.default.createElement(PrimarySecondary, {
      scopeId: scopeId,
      contextId: contextId,
      eventId: eventId,
      primary: primary,
      secondary: secondary,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 155,
        columnNumber: 9
      }
    });
  }
});
PrimarySecondaryUserInfo.displayName = 'PrimarySecondaryUserInfo';