"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimelineModalHeader = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _common = require("@kbn/data-plugin/common");
var _common2 = require("@kbn/kibana-react-plugin/common");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _use_data_view = require("../../../../data_view_manager/hooks/use_data_view");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _containers = require("../../../../sourcerer/containers");
var _model = require("../../../../sourcerer/store/model");
var _new_timeline_button = require("../actions/new_timeline_button");
var _open_timeline_button = require("../actions/open_timeline_button");
var _common3 = require("../../../../../common");
var _selectors = require("../../../store/selectors");
var _helpers = require("../../../../common/utils/global_query_string/helpers");
var _store = require("../../../store");
var _kibana = require("../../../../common/lib/kibana");
var _kuery = require("../../../../common/lib/kuery");
var i18n = _interopRequireWildcard(require("../translations"));
var _add_to_favorites = require("../../add_to_favorites");
var _save_status = require("../../save_status");
var _inspect = require("../../../../common/components/inspect");
var _constants = require("../../../../common/store/inputs/constants");
var _attach_to_case_button = require("../actions/attach_to_case_button");
var _save_timeline_button = require("../actions/save_timeline_button");
var _use_browser_fields = require("../../../../data_view_manager/hooks/use_browser_fields");
var _constants2 = require("../../../../data_view_manager/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/modal/header/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const whiteSpaceNoWrapCSS = {
  'white-space': 'nowrap'
};
const autoOverflowXCSS = {
  'overflow-x': 'auto'
};
const VerticalDivider = _styledComponents.default.span`
  width: 0;
  height: 20px;
  border-left: 1px solid ${({
  theme
}) => theme.eui.euiColorLightShade};
`;
const TimelinePanel = (0, _common2.euiStyled)(_eui.EuiPanel)`
  backgroundColor: ${props => props.theme.eui.euiColorEmptyShade};
  color: ${props => props.theme.eui.euiTextColor};
  padding-inline: ${props => props.theme.eui.euiSizeM};
  border-radius: ${({
  theme
}) => theme.eui.euiBorderRadius};
`;
/**
 * Component rendered at the top of the timeline modal. It contains the timeline title, all the action buttons (save, open, favorite...) and the close button
 */
const TimelineModalHeader = exports.TimelineModalHeader = /*#__PURE__*/_react.default.memo(({
  timelineId,
  openToggleRef
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const {
    browserFields: sourcererBrowserFields,
    sourcererDataView: oldSourcererDataViewSpec
  } = (0, _containers.useSourcererDataView)(_model.SourcererScopeName.timeline);
  const {
    dataView: experimentalDataView
  } = (0, _use_data_view.useDataView)(_constants2.DataViewManagerScopeName.timeline);
  const experimentalBrowserFields = (0, _use_browser_fields.useBrowserFields)(_constants2.DataViewManagerScopeName.timeline);
  const browserFields = (0, _react.useMemo)(() => newDataViewPickerEnabled ? experimentalBrowserFields : sourcererBrowserFields, [experimentalBrowserFields, newDataViewPickerEnabled, sourcererBrowserFields]);
  const {
    cases,
    uiSettings
  } = (0, _kibana.useKibana)().services;
  const esQueryConfig = (0, _react.useMemo)(() => (0, _common.getEsQueryConfig)(uiSettings), [uiSettings]);
  const userCasesPermissions = (0, _react.useMemo)(() => cases.helpers.canUseCases([_common3.APP_ID]), [cases]);
  const title = (0, _reactRedux.useSelector)(state => (0, _selectors.selectTitleByTimelineById)(state, timelineId));
  const isDataInTimeline = (0, _reactRedux.useSelector)(state => (0, _selectors.selectDataInTimeline)(state, timelineId));
  const kqlQueryObj = (0, _reactRedux.useSelector)(state => (0, _selectors.selectKqlQuery)(state, timelineId));
  const {
    activeTab,
    dataProviders,
    timelineType,
    filters,
    kqlMode
  } = (0, _reactRedux.useSelector)(state => (0, _selectors.selectTimelineById)(state, timelineId));
  const combinedQueries = (0, _react.useMemo)(() => (0, _kuery.combineQueries)({
    config: esQueryConfig,
    dataProviders,
    dataViewSpec: oldSourcererDataViewSpec,
    dataView: experimentalDataView,
    browserFields,
    filters: filters ? filters : [],
    kqlQuery: kqlQueryObj,
    kqlMode
  }), [browserFields, dataProviders, esQueryConfig, experimentalDataView, filters, kqlMode, kqlQueryObj, oldSourcererDataViewSpec]);
  const isInspectDisabled = !isDataInTimeline || (combinedQueries === null || combinedQueries === void 0 ? void 0 : combinedQueries.filterQuery) === undefined;
  const closeTimeline = (0, _react.useCallback)(() => {
    if (openToggleRef.current != null) {
      openToggleRef.current.focus();
    }
    (0, _helpers.createHistoryEntry)();
    dispatch(_store.timelineActions.showTimeline({
      id: timelineId,
      show: false
    }));
  }, [dispatch, timelineId, openToggleRef]);
  return /*#__PURE__*/_react.default.createElement(TimelinePanel, {
    grow: false,
    paddingSize: "s",
    hasShadow: false,
    "data-test-subj": "timeline-modal-header-panel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: "eui-scrollBar",
    alignItems: "center",
    gutterSize: "s",
    responsive: false,
    justifyContent: "spaceBetween",
    css: autoOverflowXCSS,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_add_to_favorites.AddToFavoritesButton, {
    timelineId: timelineId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    grow: false,
    "data-test-subj": "timeline-modal-header-title",
    css: whiteSpaceNoWrapCSS,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 19
    }
  }, title))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_save_status.TimelineSaveStatus, {
    timelineId: timelineId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 17
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    alignItems: "center",
    gutterSize: "xs",
    responsive: false,
    "data-test-subj": "timeline-modal-header-actions",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_new_timeline_button.NewTimelineButton, {
    timelineId: timelineId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_open_timeline_button.OpenTimelineButton, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_inspect.InspectButton, {
    queryId: `${timelineId}-${activeTab}`,
    inputId: _constants.InputsModelId.timeline,
    isDisabled: isInspectDisabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 17
    }
  })), userCasesPermissions.createComment && userCasesPermissions.read ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(VerticalDivider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 21
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_attach_to_case_button.AttachToCaseButton, {
    timelineId: timelineId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 21
    }
  }))) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_save_timeline_button.SaveTimelineButton, {
    timelineId: timelineId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: i18n.CLOSE_TIMELINE_OR_TEMPLATE(timelineType === 'default'),
    disableScreenReaderOutput: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": i18n.CLOSE_TIMELINE_OR_TEMPLATE(timelineType === 'default'),
    iconType: "cross",
    "data-test-subj": "timeline-modal-header-close-button",
    onClick: closeTimeline,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 19
    }
  })))))));
});
TimelineModalHeader.displayName = 'TimelineModalHeader';