"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Ja3Fingerprint = exports.JA3_HASH_FIELD_NAME = void 0;
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _draggables = require("../../../common/components/draggables");
var _links = require("../../../common/components/links");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/ja3_fingerprint/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const JA3_HASH_FIELD_NAME = exports.JA3_HASH_FIELD_NAME = 'tls.fingerprints.ja3.hash';
const Ja3FingerprintLabel = _styledComponents.default.span`
  margin-right: 5px;
`;
Ja3FingerprintLabel.displayName = 'Ja3FingerprintLabel';

/**
 * Renders a ja3 fingerprint, which enables (some) clients and servers communicating
 * using TLS traffic to be identified, which is possible because SSL
 * negotiations happen in the clear
 */
const Ja3Fingerprint = exports.Ja3Fingerprint = /*#__PURE__*/_react.default.memo(({
  contextId,
  eventId,
  fieldName,
  value,
  scopeId
}) => /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
  scopeId: scopeId,
  contextId: contextId,
  "data-test-subj": "ja3-hash",
  eventId: eventId,
  field: fieldName,
  iconType: "snowflake",
  value: value,
  isAggregatable: true,
  fieldType: "keyword",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 36,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(Ja3FingerprintLabel, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 47,
    columnNumber: 5
  }
}, i18n.JA3_FINGERPRINT_LABEL), /*#__PURE__*/_react.default.createElement(_links.Ja3FingerprintLink, {
  "data-test-subj": "ja3-hash-link",
  ja3Fingerprint: value || '',
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 48,
    columnNumber: 5
  }
})));
Ja3Fingerprint.displayName = 'Ja3Fingerprint';